/*
 * Decompiled with CFR 0.152.
 */
package vuegwt.shaded.com.helger.commons.io.file;

import java.io.File;
import java.util.NoSuchElementException;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import vuegwt.shaded.com.helger.commons.ValueEnforcer;
import vuegwt.shaded.com.helger.commons.annotation.OverrideOnDemand;
import vuegwt.shaded.com.helger.commons.collection.impl.ICommonsList;
import vuegwt.shaded.com.helger.commons.collection.iterate.IIterableIterator;
import vuegwt.shaded.com.helger.commons.functional.IPredicate;
import vuegwt.shaded.com.helger.commons.io.file.FileHelper;
import vuegwt.shaded.com.helger.commons.string.StringHelper;
import vuegwt.shaded.com.helger.commons.string.ToStringGenerator;

@NotThreadSafe
public class FileSystemRecursiveIterator
implements IIterableIterator<File> {
    private final int m_nStartLevel;
    private int m_nLevel = 0;
    private final IPredicate<File> m_aRecursionFilter;
    private final ICommonsList<File> m_aFilesLeft;

    @Nonnegative
    private static int _getLevel(@Nonnull File file) {
        return StringHelper.getCharCount(file.getAbsolutePath(), File.separatorChar);
    }

    public FileSystemRecursiveIterator(@Nonnull String string) {
        this(new File(string), (IPredicate<File>)null);
    }

    public FileSystemRecursiveIterator(@Nonnull File file) {
        this(file, (IPredicate<File>)null);
    }

    public FileSystemRecursiveIterator(@Nonnull String string, @Nullable IPredicate<File> iPredicate) {
        this(new File(string), iPredicate);
    }

    public FileSystemRecursiveIterator(@Nonnull File file, @Nullable IPredicate<File> iPredicate) {
        ValueEnforcer.notNull(file, "BaseDirectory");
        this.m_nStartLevel = FileSystemRecursiveIterator._getLevel(file);
        this.m_aRecursionFilter = iPredicate;
        this.m_aFilesLeft = FileHelper.getDirectoryContent(file);
    }

    @Nonnegative
    public int getStartLevel() {
        return this.m_nStartLevel;
    }

    @Nullable
    public IPredicate<File> getRecursionFilter() {
        return this.m_aRecursionFilter;
    }

    @Override
    public final boolean hasNext() {
        return this.m_aFilesLeft.isNotEmpty();
    }

    @OverrideOnDemand
    protected boolean recurseIntoDirectory(@Nonnull File file) {
        return this.m_aRecursionFilter == null || this.m_aRecursionFilter.test(file);
    }

    @Override
    @Nonnull
    public final File next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        File file = this.m_aFilesLeft.removeFirst();
        this.m_nLevel = FileSystemRecursiveIterator._getLevel(file) - this.m_nStartLevel;
        if (file.isDirectory() && this.recurseIntoDirectory(file)) {
            this.m_aFilesLeft.addAll(0, FileHelper.getDirectoryContent(file));
        }
        return file;
    }

    @Nonnegative
    public final int getLevel() {
        return this.m_nLevel;
    }

    public String toString() {
        return new ToStringGenerator(this).append("FilesLeft", this.m_aFilesLeft).getToString();
    }
}

