/*
 * Decompiled with CFR 0.152.
 */
package vuegwt.shaded.com.helger.commons.io.file;

import java.io.File;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import vuegwt.shaded.com.helger.commons.io.file.EFileIOErrorCode;
import vuegwt.shaded.com.helger.commons.io.file.EFileIOOperation;
import vuegwt.shaded.com.helger.commons.io.file.IFileOperationCallback;
import vuegwt.shaded.org.slf4j.Logger;
import vuegwt.shaded.org.slf4j.LoggerFactory;

public class LoggingFileOperationCallback
implements IFileOperationCallback {
    private static final Logger s_aLogger = LoggerFactory.getLogger(LoggingFileOperationCallback.class);

    @Override
    public void onSuccess(@Nonnull EFileIOOperation eFileIOOperation, @Nonnull File file, @Nullable File file2) {
        if (s_aLogger.isDebugEnabled()) {
            s_aLogger.debug("File operation " + eFileIOOperation.name() + " succeeded on '" + file + "'" + (file2 == null ? "" : " and '" + file2 + "'"));
        }
    }

    @Override
    public void onError(@Nonnull EFileIOOperation eFileIOOperation, @Nonnull EFileIOErrorCode eFileIOErrorCode, @Nonnull File file, @Nullable File file2, @Nullable Exception exception) {
        s_aLogger.warn("File operation " + eFileIOOperation.name() + " failed with error code " + eFileIOErrorCode.name() + " on '" + file + "'" + (file2 == null ? "" : " and '" + file2 + "'"), exception);
    }
}

