/*
 * Decompiled with CFR 0.152.
 */
package vuegwt.shaded.com.helger.commons.io.file;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import vuegwt.shaded.com.helger.commons.ValueEnforcer;
import vuegwt.shaded.com.helger.commons.annotation.ReturnsMutableCopy;
import vuegwt.shaded.com.helger.commons.collection.impl.CommonsArrayList;
import vuegwt.shaded.com.helger.commons.collection.impl.ICommonsList;
import vuegwt.shaded.com.helger.commons.io.EAppend;
import vuegwt.shaded.com.helger.commons.io.file.FileIOError;
import vuegwt.shaded.com.helger.commons.io.file.FilenameHelper;
import vuegwt.shaded.com.helger.commons.io.file.PathOperations;
import vuegwt.shaded.com.helger.commons.io.stream.NonBlockingBufferedInputStream;
import vuegwt.shaded.com.helger.commons.io.stream.NonBlockingBufferedOutputStream;
import vuegwt.shaded.com.helger.commons.io.stream.NonBlockingBufferedReader;
import vuegwt.shaded.com.helger.commons.io.stream.NonBlockingBufferedWriter;
import vuegwt.shaded.com.helger.commons.io.stream.StreamHelper;
import vuegwt.shaded.com.helger.commons.state.EChange;
import vuegwt.shaded.org.slf4j.Logger;
import vuegwt.shaded.org.slf4j.LoggerFactory;

@Immutable
public final class PathHelper {
    private static final Logger s_aLogger = LoggerFactory.getLogger(PathHelper.class);
    private static final PathHelper s_aInstance = new PathHelper();

    private PathHelper() {
    }

    public static boolean canReadAndWriteFile(@Nullable Path path) {
        Path path2;
        if (path == null) {
            return false;
        }
        return !(Files.isRegularFile(path, new LinkOption[0]) ? !Files.isReadable(path) || !Files.isWritable(path) : (path2 = path.getParent()) == null || !Files.isDirectory(path2, new LinkOption[0]) || !Files.isReadable(path2) || !Files.isWritable(path2));
    }

    @Nonnull
    public static EChange ensureParentDirectoryIsPresent(@Nonnull Path path) {
        ValueEnforcer.notNull(path, "Path");
        Path path2 = path.getParent();
        if (path2 == null || Files.exists(path2, new LinkOption[0])) {
            if (path2 != null && !Files.isDirectory(path2, new LinkOption[0])) {
                s_aLogger.warn("Parent object specified is not a directory: '" + path2 + "'");
            }
            return EChange.UNCHANGED;
        }
        FileIOError fileIOError = PathOperations.createDirRecursive(path2);
        if (fileIOError.isFailure()) {
            throw new IllegalStateException("Failed to create parent of " + path.toAbsolutePath() + ": " + fileIOError);
        }
        if (!Files.exists(path2, new LinkOption[0])) {
            throw new IllegalStateException("Parent of " + path.toAbsolutePath() + " is still not existing!");
        }
        return EChange.CHANGED;
    }

    @Nullable
    public static Path getCanonicalFile(@Nullable Path path) throws IOException {
        return path == null ? null : path.toRealPath(new LinkOption[0]);
    }

    @Nullable
    public static Path getCanonicalFileOrNull(@Nullable Path path) {
        if (path != null) {
            try {
                return path.toRealPath(new LinkOption[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public static String getCanonicalPath(@Nullable Path path) throws IOException {
        return path == null ? null : path.toRealPath(new LinkOption[0]).toString();
    }

    @Nullable
    public static String getCanonicalPathOrNull(@Nullable Path path) {
        if (path != null) {
            try {
                return path.toRealPath(new LinkOption[0]).toString();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    @SuppressFBWarnings(value={"IL_INFINITE_LOOP"})
    public static boolean isParentDirectory(@Nonnull Path path, @Nonnull Path path2) {
        ValueEnforcer.notNull(path, "SearchDirectory");
        ValueEnforcer.notNull(path2, "StartDirectory");
        Path path3 = path.toAbsolutePath();
        Path path4 = path2.toAbsolutePath();
        try {
            path3 = PathHelper.getCanonicalFile(path3);
            path4 = PathHelper.getCanonicalFile(path4);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (Files.isDirectory(path3, new LinkOption[0])) {
            for (Path path5 = path4; path5 != null; path5 = path5.getParent()) {
                if (!path5.equals(path3)) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static InputStream getInputStream(@Nonnull Path path) {
        ValueEnforcer.notNull(path, "Path");
        try {
            return Files.newInputStream(path, new OpenOption[0]);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Nullable
    public static NonBlockingBufferedInputStream getBufferedInputStream(@Nonnull Path path) {
        ValueEnforcer.notNull(path, "File");
        InputStream inputStream = PathHelper.getInputStream(path);
        if (inputStream == null) {
            return null;
        }
        return new NonBlockingBufferedInputStream(inputStream);
    }

    @Nullable
    public static Reader getReader(@Nonnull Path path, @Nonnull Charset charset) {
        ValueEnforcer.notNull(path, "Path");
        ValueEnforcer.notNull(charset, "Charset");
        return StreamHelper.createReader(PathHelper.getInputStream(path), charset);
    }

    @Nullable
    public static NonBlockingBufferedReader getBufferedReader(@Nonnull Path path, @Nonnull Charset charset) {
        ValueEnforcer.notNull(path, "Path");
        ValueEnforcer.notNull(charset, "Charset");
        Reader reader = PathHelper.getReader(path, charset);
        if (reader == null) {
            return null;
        }
        return new NonBlockingBufferedReader(reader);
    }

    @Nullable
    public static OutputStream getOutputStream(@Nonnull Path path) {
        return PathHelper.getOutputStream(path, EAppend.DEFAULT);
    }

    @Nullable
    public static OutputStream getOutputStream(@Nonnull Path path, @Nonnull EAppend eAppend) {
        ValueEnforcer.notNull(path, "Path");
        ValueEnforcer.notNull(eAppend, "Append");
        try {
            return Files.newOutputStream(path, eAppend.getAsOpenOptions());
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Nullable
    public static NonBlockingBufferedOutputStream getBufferedOutputStream(@Nonnull Path path) {
        return PathHelper.getBufferedOutputStream(path, EAppend.DEFAULT);
    }

    @Nullable
    public static NonBlockingBufferedOutputStream getBufferedOutputStream(@Nonnull Path path, @Nonnull EAppend eAppend) {
        ValueEnforcer.notNull(path, "File");
        ValueEnforcer.notNull(eAppend, "Append");
        OutputStream outputStream = PathHelper.getOutputStream(path, eAppend);
        if (outputStream == null) {
            return null;
        }
        return new NonBlockingBufferedOutputStream(outputStream);
    }

    @Nullable
    public static Writer getWriter(@Nonnull Path path, @Nonnull EAppend eAppend, @Nonnull Charset charset) {
        ValueEnforcer.notNull(path, "Path");
        ValueEnforcer.notNull(charset, "Charset");
        return StreamHelper.createWriter(PathHelper.getOutputStream(path, eAppend), charset);
    }

    @Nullable
    public static NonBlockingBufferedWriter getBufferedWriter(@Nonnull Path path, @Nonnull EAppend eAppend, @Nonnull Charset charset) {
        ValueEnforcer.notNull(path, "Path");
        ValueEnforcer.notNull(charset, "Charset");
        Writer writer = PathHelper.getWriter(path, eAppend, charset);
        if (writer == null) {
            return null;
        }
        return new NonBlockingBufferedWriter(writer);
    }

    public static boolean isFileNewer(@Nonnull Path path, @Nonnull Path path2) {
        ValueEnforcer.notNull(path, "File1");
        ValueEnforcer.notNull(path2, "aFile2");
        if (path.equals(path2)) {
            return false;
        }
        if (!Files.exists(path, new LinkOption[0])) {
            return false;
        }
        if (!Files.exists(path2, new LinkOption[0])) {
            return true;
        }
        try {
            return Files.getLastModifiedTime(path, new LinkOption[0]).compareTo(Files.getLastModifiedTime(path2, new LinkOption[0])) > 0;
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Nonnegative
    public static int getDirectoryObjectCount(@Nonnull Path path) {
        ValueEnforcer.notNull(path, "Directory");
        ValueEnforcer.isTrue(Files.isDirectory(path, new LinkOption[0]), "Passed object is not a directory: " + path);
        int n = 0;
        for (Path path2 : PathHelper.getDirectoryContent(path)) {
            if (FilenameHelper.isSystemInternalDirectory(path2)) continue;
            ++n;
        }
        return n;
    }

    @Nonnull
    public static Path walkFileTree(@Nonnull Path path, @Nonnegative int n, @Nonnull FileVisitor<? super Path> fileVisitor) {
        return PathHelper.walkFileTree(path, EnumSet.noneOf(FileVisitOption.class), n, fileVisitor);
    }

    @Nonnull
    public static Path walkFileTree(@Nonnull Path path, @Nonnull Set<FileVisitOption> set, @Nonnegative int n, @Nonnull FileVisitor<? super Path> fileVisitor) {
        try {
            return Files.walkFileTree(path, set, n, fileVisitor);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Nonnull
    @ReturnsMutableCopy
    private static ICommonsList<Path> _getDirectoryContent(@Nonnull Path path, final @Nullable Predicate<? super Path> predicate) {
        final CommonsArrayList<Path> commonsArrayList = new CommonsArrayList<Path>();
        PathHelper.walkFileTree(path, 1, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                if (predicate == null || predicate.test(path)) {
                    commonsArrayList.add(path);
                }
                return FileVisitResult.CONTINUE;
            }
        });
        if (commonsArrayList.isEmpty()) {
            if (predicate == null) {
                if (!Files.isDirectory(path, new LinkOption[0])) {
                    s_aLogger.warn("Cannot list non-directory: " + path.toAbsolutePath());
                } else if (!Files.isExecutable(path)) {
                    s_aLogger.warn("Existing directory is missing the listing permission: " + path.toAbsolutePath());
                } else if (!Files.isReadable(path)) {
                    s_aLogger.warn("Cannot list directory because of no read-rights: " + path.toAbsolutePath());
                } else if (!Files.exists(path, new LinkOption[0])) {
                    s_aLogger.warn("Cannot list non-existing: " + path.toAbsolutePath());
                }
            }
        } else if (!Files.isExecutable(path)) {
            s_aLogger.warn("Directory is missing the listing permission: " + path.toAbsolutePath());
        }
        return commonsArrayList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsList<Path> getDirectoryContent(@Nonnull Path path) {
        ValueEnforcer.notNull(path, "Directory");
        return PathHelper._getDirectoryContent(path, null);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsList<Path> getDirectoryContent(@Nonnull Path path, @Nullable Predicate<? super Path> predicate) {
        ValueEnforcer.notNull(path, "Directory");
        return PathHelper._getDirectoryContent(path, predicate);
    }

    @Nullable
    public static URL getAsURL(@Nonnull Path path) {
        ValueEnforcer.notNull(path, "Path");
        try {
            return path.toUri().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            s_aLogger.warn("Failed to convert path to URL: " + path, malformedURLException);
            return null;
        }
    }
}

