/*
 * Decompiled with CFR 0.152.
 */
package vuegwt.shaded.com.helger.commons.io.resource;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import vuegwt.shaded.com.helger.commons.ValueEnforcer;
import vuegwt.shaded.com.helger.commons.hashcode.HashCodeGenerator;
import vuegwt.shaded.com.helger.commons.io.EAppend;
import vuegwt.shaded.com.helger.commons.io.file.FileHelper;
import vuegwt.shaded.com.helger.commons.io.file.FilenameHelper;
import vuegwt.shaded.com.helger.commons.io.resource.IReadWriteResource;
import vuegwt.shaded.com.helger.commons.string.ToStringGenerator;

@NotThreadSafe
public class FileSystemResource
implements IReadWriteResource {
    private final File m_aFile;
    private final String m_sPath;
    private transient int m_nHashCode = 0;

    public FileSystemResource(@Nonnull URI uRI) {
        this(new File(uRI));
    }

    public FileSystemResource(@Nonnull String string, @Nonnull String string2) {
        this(new File(string, string2));
    }

    public FileSystemResource(@Nonnull String string) {
        this(new File(string));
    }

    public FileSystemResource(@Nonnull File file, String string) {
        this(new File(file, string));
    }

    public FileSystemResource(@Nonnull File file) {
        ValueEnforcer.notNull(file, "File");
        String string = FilenameHelper.getCleanPath(file.getAbsolutePath());
        this.m_aFile = new File(string);
        this.m_sPath = this.m_aFile.getAbsolutePath();
    }

    public FileSystemResource(@Nonnull Path path) {
        this(path.toFile());
    }

    @Override
    @Nonnull
    public String getResourceID() {
        return this.getPath();
    }

    @Override
    @Nonnull
    public String getPath() {
        return this.m_sPath;
    }

    @Override
    @Nullable
    public FileInputStream getInputStream() {
        return FileHelper.getInputStream(this.m_aFile);
    }

    @Override
    @Nullable
    public Reader getReader(@Nonnull Charset charset) {
        return FileHelper.getReader(this.m_aFile, charset);
    }

    @Override
    public final boolean isReadMultiple() {
        return true;
    }

    @Override
    @Nullable
    public FileOutputStream getOutputStream(@Nonnull EAppend eAppend) {
        return FileHelper.getOutputStream(this.m_aFile, eAppend);
    }

    @Override
    @Nullable
    public Writer getWriter(@Nonnull Charset charset, @Nonnull EAppend eAppend) {
        return FileHelper.getWriter(this.m_aFile, eAppend, charset);
    }

    @Override
    public final boolean isWriteMultiple() {
        return true;
    }

    @Override
    public boolean exists() {
        return this.m_aFile.exists();
    }

    @Override
    @Nullable
    public URL getAsURL() {
        return FileHelper.getAsURL(this.m_aFile);
    }

    @Override
    @Nonnull
    public File getAsFile() {
        return this.m_aFile;
    }

    @Override
    @Nonnull
    public FileSystemResource getReadableCloneForPath(@Nonnull String string) {
        return new FileSystemResource(string);
    }

    @Override
    @Nonnull
    public FileSystemResource getWritableCloneForPath(@Nonnull String string) {
        return new FileSystemResource(string);
    }

    public boolean canRead() {
        return this.m_aFile.canRead();
    }

    public boolean canWrite() {
        return this.m_aFile.canWrite();
    }

    public boolean canExecute() {
        return this.m_aFile.canExecute();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        FileSystemResource fileSystemResource = (FileSystemResource)object;
        return this.m_aFile.equals(fileSystemResource.m_aFile);
    }

    public int hashCode() {
        int n = this.m_nHashCode;
        if (n == 0) {
            n = this.m_nHashCode = new HashCodeGenerator(this).append(this.m_aFile).getHashCode();
        }
        return n;
    }

    public String toString() {
        return new ToStringGenerator(null).append("file", this.m_aFile).getToString();
    }
}

