/*
 * Decompiled with CFR 0.152.
 */
package vuegwt.shaded.com.helger.commons.io.resource;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.function.Consumer;
import javax.annotation.CheckForSigned;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import vuegwt.shaded.com.helger.commons.ValueEnforcer;
import vuegwt.shaded.com.helger.commons.equals.EqualsHelper;
import vuegwt.shaded.com.helger.commons.hashcode.HashCodeGenerator;
import vuegwt.shaded.com.helger.commons.io.resource.IReadableResource;
import vuegwt.shaded.com.helger.commons.io.stream.StreamHelper;
import vuegwt.shaded.com.helger.commons.string.ToStringGenerator;
import vuegwt.shaded.com.helger.commons.url.ISimpleURL;
import vuegwt.shaded.com.helger.commons.url.URLHelper;
import vuegwt.shaded.com.helger.commons.wrapper.IMutableWrapper;
import vuegwt.shaded.org.slf4j.Logger;
import vuegwt.shaded.org.slf4j.LoggerFactory;

@Immutable
public class URLResource
implements IReadableResource {
    public static final int DEFAULT_CONNECT_TIMEOUT = -1;
    public static final int DEFAULT_READ_TIMEOUT = -1;
    private static final Logger s_aLogger = LoggerFactory.getLogger(URLResource.class);
    private final URL m_aURL;

    public URLResource(@Nonnull ISimpleURL iSimpleURL) throws MalformedURLException {
        this(iSimpleURL.getAsStringWithEncodedParameters());
    }

    public URLResource(@Nonnull String string) throws MalformedURLException {
        this(new URL(string));
    }

    public URLResource(@Nonnull URI uRI) throws MalformedURLException {
        this(uRI.toURL());
    }

    public URLResource(@Nonnull URL uRL) {
        this.m_aURL = ValueEnforcer.notNull(uRL, "URL");
    }

    public static boolean isExplicitURLResource(@Nullable String string) {
        return URLHelper.getAsURL(string, false) != null;
    }

    @Override
    @Nonnull
    public String getResourceID() {
        return this.getPath();
    }

    @Override
    @Nonnull
    public String getPath() {
        return this.m_aURL.toExternalForm();
    }

    @Nullable
    public static InputStream getInputStream(@Nonnull URL uRL) {
        return URLHelper.getInputStream(uRL, -1, -1, null, null);
    }

    @Override
    @Nullable
    public InputStream getInputStream() {
        return this.getInputStream(-1, -1);
    }

    @Nullable
    public InputStream getInputStream(@CheckForSigned int n, @CheckForSigned int n2) {
        return this.getInputStream(n, n2, null, null);
    }

    @Nullable
    public InputStream getInputStream(@Nullable IMutableWrapper<IOException> iMutableWrapper) {
        return this.getInputStream(-1, -1, iMutableWrapper);
    }

    @Nullable
    public InputStream getInputStream(@CheckForSigned int n, @CheckForSigned int n2, @Nullable IMutableWrapper<IOException> iMutableWrapper) {
        return this.getInputStream(n, n2, null, iMutableWrapper);
    }

    @Nullable
    public InputStream getInputStream(@CheckForSigned int n, @CheckForSigned int n2, @Nullable Consumer<? super URLConnection> consumer, @Nullable IMutableWrapper<IOException> iMutableWrapper) {
        return URLHelper.getInputStream(this.m_aURL, n, n2, consumer, iMutableWrapper);
    }

    @Override
    public final boolean isReadMultiple() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists() {
        if ("file".equals(this.m_aURL.getProtocol())) {
            return this.getAsFile().exists();
        }
        InputStream inputStream = null;
        try {
            inputStream = this.getInputStream();
            boolean bl = inputStream != null;
            return bl;
        }
        catch (Exception exception) {
            boolean bl = false;
            return bl;
        }
        finally {
            StreamHelper.close(inputStream);
        }
    }

    @Override
    @Nonnull
    public URL getAsURL() {
        return this.m_aURL;
    }

    @Nullable
    public URI getAsURI() {
        return URLHelper.getAsURI(this.m_aURL);
    }

    @Override
    @Nonnull
    public File getAsFile() {
        return URLHelper.getAsFile(this.m_aURL);
    }

    @Nonnull
    public URLResource getReadableCloneForPath(@Nonnull URL uRL) {
        return new URLResource(uRL);
    }

    @Override
    @Nonnull
    public URLResource getReadableCloneForPath(@Nonnull String string) {
        try {
            return new URLResource(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException("Cannot convert to an URL: " + string, malformedURLException);
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        URLResource uRLResource = (URLResource)object;
        return EqualsHelper.equals(this.m_aURL, uRLResource.m_aURL);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aURL).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("url", this.m_aURL).getToString();
    }
}

