/*
 * Decompiled with CFR 0.152.
 */
package vuegwt.shaded.com.helger.commons.io.resourceprovider;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import vuegwt.shaded.com.helger.commons.ValueEnforcer;
import vuegwt.shaded.com.helger.commons.equals.EqualsHelper;
import vuegwt.shaded.com.helger.commons.hashcode.HashCodeGenerator;
import vuegwt.shaded.com.helger.commons.io.resource.ClassPathResource;
import vuegwt.shaded.com.helger.commons.io.resource.IReadableResource;
import vuegwt.shaded.com.helger.commons.io.resourceprovider.IReadableResourceProvider;
import vuegwt.shaded.com.helger.commons.string.StringHelper;
import vuegwt.shaded.com.helger.commons.string.ToStringGenerator;

@Immutable
public final class ClassPathResourceProvider
implements IReadableResourceProvider {
    private final String m_sPrefix;

    public ClassPathResourceProvider() {
        this(null);
    }

    public ClassPathResourceProvider(@Nullable String string) {
        this.m_sPrefix = string;
    }

    @Nullable
    public String getPrefix() {
        return this.m_sPrefix;
    }

    @Override
    public boolean supportsReading(@Nullable String string) {
        return StringHelper.hasText(string);
    }

    @Override
    @Nonnull
    public IReadableResource getReadableResource(@Nonnull String string) {
        ValueEnforcer.notNull(string, "Name");
        return new ClassPathResource(this.m_sPrefix == null ? string : this.m_sPrefix + string);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        ClassPathResourceProvider classPathResourceProvider = (ClassPathResourceProvider)object;
        return EqualsHelper.equals(this.m_sPrefix, classPathResourceProvider.m_sPrefix);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_sPrefix).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).appendIfNotNull("prefix", this.m_sPrefix).getToString();
    }
}

