/*
 * Decompiled with CFR 0.152.
 */
package vuegwt.shaded.com.helger.commons.io.resourceprovider;

import java.io.InputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import vuegwt.shaded.com.helger.commons.ValueEnforcer;
import vuegwt.shaded.com.helger.commons.annotation.Nonempty;
import vuegwt.shaded.com.helger.commons.annotation.OverrideOnDemand;
import vuegwt.shaded.com.helger.commons.annotation.ReturnsMutableCopy;
import vuegwt.shaded.com.helger.commons.collection.impl.CommonsArrayList;
import vuegwt.shaded.com.helger.commons.collection.impl.ICommonsList;
import vuegwt.shaded.com.helger.commons.hashcode.HashCodeGenerator;
import vuegwt.shaded.com.helger.commons.io.resource.IReadableResource;
import vuegwt.shaded.com.helger.commons.io.resourceprovider.IReadableResourceProvider;
import vuegwt.shaded.com.helger.commons.string.ToStringGenerator;

@Immutable
public class ReadableResourceProviderChain
implements IReadableResourceProvider {
    protected final ICommonsList<IReadableResourceProvider> m_aReadingResourceProviders;

    public ReadableResourceProviderChain(IReadableResourceProvider ... iReadableResourceProviderArray) {
        ValueEnforcer.notEmptyNoNullValue(iReadableResourceProviderArray, "ResourceProviders");
        this.m_aReadingResourceProviders = new CommonsArrayList<IReadableResourceProvider>(iReadableResourceProviderArray);
    }

    public ReadableResourceProviderChain(@Nonnull Iterable<? extends IReadableResourceProvider> iterable) {
        ValueEnforcer.notEmptyNoNullValue(iterable, "ResourceProviders");
        this.m_aReadingResourceProviders = new CommonsArrayList<Iterable<? extends IReadableResourceProvider>>(iterable);
    }

    @Nonnull
    @Nonempty
    @ReturnsMutableCopy
    public ICommonsList<IReadableResourceProvider> getAllContainedReadingResourceProviders() {
        return (ICommonsList)this.m_aReadingResourceProviders.getClone();
    }

    @Override
    public final boolean supportsReading(@Nullable String string) {
        return this.m_aReadingResourceProviders.containsAny(iReadableResourceProvider -> iReadableResourceProvider.supportsReading(string));
    }

    @Override
    @Nonnull
    @OverrideOnDemand
    public IReadableResource getReadableResource(@Nonnull String string) {
        for (IReadableResourceProvider iReadableResourceProvider : this.m_aReadingResourceProviders) {
            if (!iReadableResourceProvider.supportsReading(string)) continue;
            return iReadableResourceProvider.getReadableResource(string);
        }
        throw new IllegalArgumentException("Cannot handle reading '" + string + "' by any of " + this.m_aReadingResourceProviders);
    }

    @Override
    @Nullable
    public InputStream getInputStream(@Nonnull String string) {
        for (IReadableResourceProvider iReadableResourceProvider : this.m_aReadingResourceProviders) {
            InputStream inputStream = iReadableResourceProvider.getInputStream(string);
            if (inputStream == null) continue;
            return inputStream;
        }
        return null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        ReadableResourceProviderChain readableResourceProviderChain = (ReadableResourceProviderChain)object;
        return this.m_aReadingResourceProviders.equals(readableResourceProviderChain.m_aReadingResourceProviders);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append(this.m_aReadingResourceProviders)).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("readableResProviders", this.m_aReadingResourceProviders).getToString();
    }
}

