/*
 * Decompiled with CFR 0.152.
 */
package vuegwt.shaded.com.helger.commons.io.resourceprovider;

import java.net.MalformedURLException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import vuegwt.shaded.com.helger.commons.ValueEnforcer;
import vuegwt.shaded.com.helger.commons.hashcode.HashCodeGenerator;
import vuegwt.shaded.com.helger.commons.io.resource.IReadableResource;
import vuegwt.shaded.com.helger.commons.io.resource.URLResource;
import vuegwt.shaded.com.helger.commons.io.resourceprovider.IReadableResourceProvider;
import vuegwt.shaded.com.helger.commons.string.ToStringGenerator;

@Immutable
public final class URLResourceProvider
implements IReadableResourceProvider {
    @Override
    public boolean supportsReading(@Nullable String string) {
        return URLResource.isExplicitURLResource(string);
    }

    @Override
    public IReadableResource getReadableResource(@Nonnull String string) {
        ValueEnforcer.notNull(string, "URL");
        try {
            return new URLResource(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException("Passed name '" + string + "' is not a URL!", malformedURLException);
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        return object != null && this.getClass().equals(object.getClass());
    }

    public int hashCode() {
        return new HashCodeGenerator(this).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).getToString();
    }
}

