/*
 * Decompiled with CFR 0.152.
 */
package vuegwt.shaded.com.helger.commons.io.stream;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;
import javax.annotation.Nonnull;
import vuegwt.shaded.com.helger.commons.concurrent.SimpleLock;
import vuegwt.shaded.com.helger.commons.io.stream.NonBlockingBitInputStream;

public class BitInputStream
extends NonBlockingBitInputStream {
    private final SimpleLock m_aLock = new SimpleLock();

    public BitInputStream(@Nonnull InputStream inputStream, @Nonnull ByteOrder byteOrder) {
        super(inputStream, byteOrder);
    }

    @Override
    public int readBit() throws IOException {
        this.m_aLock.lock();
        try {
            int n = super.readBit();
            return n;
        }
        finally {
            this.m_aLock.unlock();
        }
    }

    @Override
    public void close() {
        this.m_aLock.locked(() -> super.close());
    }
}

