/*
 * Decompiled with CFR 0.152.
 */
package vuegwt.shaded.com.helger.commons.io.stream;

import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import vuegwt.shaded.com.helger.commons.ValueEnforcer;
import vuegwt.shaded.com.helger.commons.io.stream.StreamHelper;
import vuegwt.shaded.com.helger.commons.string.ToStringGenerator;

public class NonBlockingBitInputStream
implements Closeable {
    private InputStream m_aIS;
    private final boolean m_bHighOrderBitFirst;
    private int m_nNextBitIndex;
    private int m_nBuffer;

    public NonBlockingBitInputStream(@Nonnull InputStream inputStream, @Nonnull ByteOrder byteOrder) {
        ValueEnforcer.notNull(inputStream, "InputStream");
        ValueEnforcer.notNull(byteOrder, "ByteOrder");
        this.m_aIS = StreamHelper.getBuffered(inputStream);
        this.m_bHighOrderBitFirst = byteOrder.equals(ByteOrder.LITTLE_ENDIAN);
        this.m_nNextBitIndex = 8;
    }

    @Nonnull
    public ByteOrder getByteOrder() {
        return this.m_bHighOrderBitFirst ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
    }

    public int readBits(@Nonnegative int n) throws IOException {
        ValueEnforcer.isBetweenInclusive(n, "NumberOfBits", 1, 32);
        int n2 = 0;
        for (int i = n - 1; i >= 0; --i) {
            n2 |= this.readBit() << i;
        }
        return n2;
    }

    public int readBit() throws IOException {
        if (this.m_aIS == null) {
            throw new IOException("BitInputStream is already closed");
        }
        if (this.m_nNextBitIndex == 8) {
            this.m_nBuffer = this.m_aIS.read();
            if (this.m_nBuffer == -1) {
                throw new EOFException();
            }
            this.m_nNextBitIndex = 0;
        }
        int n = this.m_bHighOrderBitFirst ? 1 << 7 - this.m_nNextBitIndex : 1 << this.m_nNextBitIndex;
        int n2 = this.m_nBuffer & n;
        ++this.m_nNextBitIndex;
        return n2 == 0 ? 0 : 1;
    }

    @Override
    public void close() {
        StreamHelper.close(this.m_aIS);
        this.m_aIS = null;
    }

    public String toString() {
        return new ToStringGenerator(this).append("IS", this.m_aIS).append("highOrderBitFirst", this.m_bHighOrderBitFirst).append("nextBitIndex", this.m_nNextBitIndex).append("buffer", this.m_nBuffer).getToString();
    }
}

