/*
 * Decompiled with CFR 0.152.
 */
package vuegwt.shaded.com.helger.commons.io.stream;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.WillNotClose;
import vuegwt.shaded.com.helger.commons.ValueEnforcer;
import vuegwt.shaded.com.helger.commons.annotation.ReturnsMutableCopy;
import vuegwt.shaded.com.helger.commons.annotation.ReturnsMutableObject;
import vuegwt.shaded.com.helger.commons.collection.ArrayHelper;
import vuegwt.shaded.com.helger.commons.io.IWriteToStream;
import vuegwt.shaded.com.helger.commons.io.stream.NonBlockingByteArrayInputStream;
import vuegwt.shaded.com.helger.commons.lang.IHasSize;
import vuegwt.shaded.com.helger.commons.string.ToStringGenerator;

public class NonBlockingByteArrayOutputStream
extends OutputStream
implements IHasSize,
IWriteToStream,
Serializable {
    protected byte[] m_aBuf;
    protected int m_nCount;

    public NonBlockingByteArrayOutputStream() {
        this(32);
    }

    public NonBlockingByteArrayOutputStream(@Nonnegative int n) {
        ValueEnforcer.isGE0(n, "Size");
        this.m_aBuf = new byte[n];
    }

    @Nonnull
    @ReturnsMutableCopy
    private static byte[] _enlarge(@Nonnull byte[] byArray, @Nonnegative int n) {
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        return byArray2;
    }

    @Override
    public void write(int n) {
        int n2 = this.m_nCount + 1;
        if (n2 > this.m_aBuf.length) {
            this.m_aBuf = NonBlockingByteArrayOutputStream._enlarge(this.m_aBuf, Math.max(this.m_aBuf.length << 1, n2));
        }
        this.m_aBuf[this.m_nCount] = (byte)n;
        this.m_nCount = n2;
    }

    @Override
    public void write(@Nonnull byte[] byArray) {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(@Nonnull byte[] byArray, int n, int n2) {
        if (n2 > 0) {
            int n3 = this.m_nCount + n2;
            if (n3 > this.m_aBuf.length) {
                this.m_aBuf = NonBlockingByteArrayOutputStream._enlarge(this.m_aBuf, Math.max(this.m_aBuf.length << 1, n3));
            }
            System.arraycopy(byArray, n, this.m_aBuf, this.m_nCount, n2);
            this.m_nCount = n3;
        }
    }

    @Override
    public void writeTo(@Nonnull @WillNotClose OutputStream outputStream) throws IOException {
        outputStream.write(this.m_aBuf, 0, this.m_nCount);
    }

    public void readFrom(@Nonnull @WillNotClose InputStream inputStream) throws IOException {
        while (true) {
            int n;
            if (this.m_nCount == this.m_aBuf.length) {
                this.m_aBuf = NonBlockingByteArrayOutputStream._enlarge(this.m_aBuf, this.m_aBuf.length << 1);
            }
            if ((n = inputStream.read(this.m_aBuf, this.m_nCount, this.m_aBuf.length - this.m_nCount)) < 0) {
                return;
            }
            this.m_nCount += n;
        }
    }

    public void reset() {
        this.m_nCount = 0;
    }

    @Nonnull
    @ReturnsMutableCopy
    public byte[] toByteArray() {
        return ArrayHelper.getCopy(this.m_aBuf, this.m_nCount);
    }

    public byte getByteAt(@Nonnegative int n) {
        ValueEnforcer.isBetweenInclusive(n, "Index", 0, this.m_nCount - 1);
        return this.m_aBuf[n];
    }

    @Nonnegative
    public int getBufferSize() {
        return this.m_aBuf.length;
    }

    @Override
    @Nonnegative
    public int size() {
        return this.m_nCount;
    }

    @Override
    public boolean isEmpty() {
        return this.m_nCount == 0;
    }

    @Override
    public boolean isNotEmpty() {
        return this.m_nCount > 0;
    }

    public boolean startsWith(@Nonnull byte[] byArray) {
        return this.startsWith(byArray, 0, byArray.length);
    }

    public boolean startsWith(@Nonnull byte[] byArray, @Nonnegative int n, @Nonnegative int n2) {
        if (this.m_nCount < n2 || n2 < 0) {
            return false;
        }
        for (int i = 0; i < n2; ++i) {
            if (this.m_aBuf[i] == byArray[n + i]) continue;
            return false;
        }
        return true;
    }

    @Nonnull
    public String getAsString(@Nonnull Charset charset) {
        return new String(this.m_aBuf, 0, this.m_nCount, charset);
    }

    @Nonnull
    public String getAsString(@Nonnegative int n, @Nonnull Charset charset) {
        ValueEnforcer.isBetweenInclusive(n, "Length", 0, this.m_nCount);
        return new String(this.m_aBuf, 0, n, charset);
    }

    @Nonnull
    public String getAsString(@Nonnegative int n, @Nonnegative int n2, @Nonnull Charset charset) {
        ValueEnforcer.isGE0(n, "Index");
        ValueEnforcer.isBetweenInclusive(n2, "Length", 0, this.m_nCount);
        return new String(this.m_aBuf, n, n2, charset);
    }

    @Nonnull
    @ReturnsMutableObject
    public byte[] directGetBuffer() {
        return this.m_aBuf;
    }

    @Override
    public void close() {
    }

    @Nonnull
    public NonBlockingByteArrayInputStream getAsInputStream() {
        return new NonBlockingByteArrayInputStream(this.m_aBuf, 0, this.m_nCount);
    }

    public String toString() {
        return new ToStringGenerator(this).append("Buf#", ArrayHelper.getSize(this.m_aBuf)).append("Count", this.m_nCount).getToString();
    }
}

