/*
 * Decompiled with CFR 0.152.
 */
package vuegwt.shaded.com.helger.commons.io.stream;

import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Arrays;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import vuegwt.shaded.com.helger.commons.ValueEnforcer;
import vuegwt.shaded.com.helger.commons.annotation.ReturnsMutableCopy;
import vuegwt.shaded.com.helger.commons.annotation.ReturnsMutableObject;
import vuegwt.shaded.com.helger.commons.string.StringHelper;

public class NonBlockingCharArrayWriter
extends Writer {
    protected char[] m_aBuf;
    protected int m_nCount;

    public NonBlockingCharArrayWriter() {
        this(32);
    }

    public NonBlockingCharArrayWriter(@Nonnegative int n) {
        ValueEnforcer.isGE0(n, "InitialSize");
        this.m_aBuf = new char[n];
    }

    @Override
    public void write(int n) {
        int n2 = this.m_nCount + 1;
        if (n2 > this.m_aBuf.length) {
            this.m_aBuf = Arrays.copyOf(this.m_aBuf, Math.max(this.m_aBuf.length << 1, n2));
        }
        this.m_aBuf[this.m_nCount] = (char)n;
        this.m_nCount = n2;
    }

    @Override
    public void write(@Nonnull char[] cArray, @Nonnegative int n, @Nonnegative int n2) {
        ValueEnforcer.isArrayOfsLen(cArray, n, n2);
        if (n2 > 0) {
            int n3 = this.m_nCount + n2;
            if (n3 > this.m_aBuf.length) {
                this.m_aBuf = Arrays.copyOf(this.m_aBuf, Math.max(this.m_aBuf.length << 1, n3));
            }
            System.arraycopy(cArray, n, this.m_aBuf, this.m_nCount, n2);
            this.m_nCount = n3;
        }
    }

    @Override
    public void write(@Nonnull String string, @Nonnegative int n, @Nonnegative int n2) {
        if (n2 > 0) {
            int n3 = this.m_nCount + n2;
            if (n3 > this.m_aBuf.length) {
                this.m_aBuf = Arrays.copyOf(this.m_aBuf, Math.max(this.m_aBuf.length << 1, n3));
            }
            string.getChars(n, n + n2, this.m_aBuf, this.m_nCount);
            this.m_nCount = n3;
        }
    }

    public void writeTo(@Nonnull Writer writer) throws IOException {
        writer.write(this.m_aBuf, 0, this.m_nCount);
    }

    @Override
    public NonBlockingCharArrayWriter append(@Nullable CharSequence charSequence) {
        String string = charSequence == null ? "null" : charSequence.toString();
        this.write(string, 0, string.length());
        return this;
    }

    @Override
    public NonBlockingCharArrayWriter append(@Nullable CharSequence charSequence, int n, int n2) {
        String string = (charSequence == null ? "null" : charSequence).subSequence(n, n2).toString();
        this.write(string, 0, string.length());
        return this;
    }

    @Override
    public NonBlockingCharArrayWriter append(char c) {
        this.write(c);
        return this;
    }

    public void reset() {
        this.m_nCount = 0;
    }

    @Nonnull
    @ReturnsMutableCopy
    public char[] toCharArray() {
        return Arrays.copyOf(this.m_aBuf, this.m_nCount);
    }

    @Nonnull
    @ReturnsMutableObject(value="by design")
    public char[] directGetBuffer() {
        return this.m_aBuf;
    }

    @Nonnull
    @ReturnsMutableCopy
    public byte[] toByteArray(@Nonnull Charset charset) {
        return StringHelper.encodeCharToBytes(this.m_aBuf, 0, this.m_nCount, charset);
    }

    @Nonnegative
    public int getSize() {
        return this.m_nCount;
    }

    @Nonnegative
    public int getBufferSize() {
        return this.m_aBuf.length;
    }

    public boolean isEmpty() {
        return this.m_nCount == 0;
    }

    public boolean isNotEmpty() {
        return this.m_nCount > 0;
    }

    public boolean startsWith(@Nonnull char[] cArray) {
        return this.startsWith(cArray, 0, cArray.length);
    }

    public boolean startsWith(@Nonnull char[] cArray, @Nonnegative int n, @Nonnegative int n2) {
        if (this.m_nCount < n2 || n2 < 0) {
            return false;
        }
        for (int i = 0; i < n2; ++i) {
            if (this.m_aBuf[i] == cArray[n + i]) continue;
            return false;
        }
        return true;
    }

    @Nonnull
    @ReturnsMutableCopy
    public String getAsString() {
        return new String(this.m_aBuf, 0, this.m_nCount);
    }

    @Nonnull
    public String getAsString(@Nonnegative int n) {
        ValueEnforcer.isBetweenInclusive(n, "Length", 0, this.m_nCount);
        return new String(this.m_aBuf, 0, n);
    }

    @Nonnull
    public String getAsString(@Nonnegative int n, @Nonnegative int n2) {
        ValueEnforcer.isGE0(n, "Index");
        ValueEnforcer.isBetweenInclusive(n2, "Length", 0, this.m_nCount);
        return new String(this.m_aBuf, n, n2);
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }
}

