/*
 * Decompiled with CFR 0.152.
 */
package vuegwt.shaded.com.helger.commons.io.streamprovider;

import java.nio.ByteBuffer;
import javax.annotation.Nonnull;
import vuegwt.shaded.com.helger.commons.ValueEnforcer;
import vuegwt.shaded.com.helger.commons.annotation.ReturnsMutableObject;
import vuegwt.shaded.com.helger.commons.io.IHasInputStreamAndReader;
import vuegwt.shaded.com.helger.commons.io.stream.ByteBufferInputStream;
import vuegwt.shaded.com.helger.commons.string.ToStringGenerator;

public class ByteBufferInputStreamProvider
implements IHasInputStreamAndReader {
    private final ByteBuffer m_aBuffer;

    public ByteBufferInputStreamProvider(@Nonnull ByteBuffer byteBuffer) {
        this.m_aBuffer = ValueEnforcer.notNull(byteBuffer, "Buffer");
    }

    @Nonnull
    @ReturnsMutableObject
    public final ByteBuffer getByteBuffer() {
        return this.m_aBuffer;
    }

    @Override
    @Nonnull
    public final ByteBufferInputStream getInputStream() {
        return new ByteBufferInputStream(this.m_aBuffer);
    }

    @Override
    public final boolean isReadMultiple() {
        return true;
    }

    public String toString() {
        return new ToStringGenerator(null).append("buffer", this.m_aBuffer).getToString();
    }
}

