/*
 * Decompiled with CFR 0.152.
 */
package vuegwt.shaded.com.helger.commons.lang;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import vuegwt.shaded.com.helger.commons.ValueEnforcer;
import vuegwt.shaded.com.helger.commons.annotation.Nonempty;
import vuegwt.shaded.com.helger.commons.io.stream.StreamHelper;
import vuegwt.shaded.com.helger.commons.lang.priviledged.IPrivilegedAction;

@Immutable
public final class ClassLoaderHelper {
    private static final ClassLoaderHelper s_aInstance = new ClassLoaderHelper();

    private ClassLoaderHelper() {
    }

    @Nonnull
    public static ClassLoader getSystemClassLoader() {
        return IPrivilegedAction.getSystemClassLoader().invokeSafe();
    }

    @Nonnull
    public static ClassLoader getContextClassLoader() {
        return IPrivilegedAction.getContextClassLoader().invokeSafe();
    }

    public static void setContextClassLoader(@Nonnull ClassLoader classLoader) {
        IPrivilegedAction.setContextClassLoader(classLoader).invokeSafe();
    }

    @Nonnull
    public static ClassLoader getClassClassLoader(@Nonnull Class<?> clazz) {
        return IPrivilegedAction.getClassLoader(clazz).invokeSafe();
    }

    @Nonnull
    public static ClassLoader getParentClassLoader(@Nonnull ClassLoader classLoader) {
        return IPrivilegedAction.classLoaderGetParent(classLoader).invokeSafe();
    }

    @Nonnull
    public static ClassLoader getDefaultClassLoader() {
        ClassLoader classLoader = null;
        try {
            classLoader = ClassLoaderHelper.getContextClassLoader();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        if (classLoader == null) {
            classLoader = ClassLoaderHelper.getClassClassLoader(ClassLoaderHelper.class);
        }
        return classLoader;
    }

    @Nonnull
    private static String _getPathWithoutLeadingSlash(@Nonnull @Nonempty String string) {
        return string.charAt(0) == '/' ? string.substring(1) : string;
    }

    @Nullable
    public static URL getResource(@Nonnull ClassLoader classLoader, @Nonnull @Nonempty String string) {
        ValueEnforcer.notNull(classLoader, "ClassLoader");
        ValueEnforcer.notEmpty(string, "Path");
        String string2 = ClassLoaderHelper._getPathWithoutLeadingSlash(string);
        return classLoader.getResource(string2);
    }

    @Nonnull
    public static Enumeration<URL> getResources(@Nonnull ClassLoader classLoader, @Nonnull @Nonempty String string) throws IOException {
        ValueEnforcer.notNull(classLoader, "ClassLoader");
        ValueEnforcer.notEmpty(string, "Path");
        String string2 = ClassLoaderHelper._getPathWithoutLeadingSlash(string);
        return classLoader.getResources(string2);
    }

    @Nullable
    public static InputStream getResourceAsStream(@Nonnull ClassLoader classLoader, @Nonnull @Nonempty String string) {
        ValueEnforcer.notNull(classLoader, "ClassLoader");
        ValueEnforcer.notEmpty(string, "Path");
        String string2 = ClassLoaderHelper._getPathWithoutLeadingSlash(string);
        InputStream inputStream = classLoader.getResourceAsStream(string2);
        return StreamHelper.checkForInvalidFilterInputStream(inputStream);
    }
}

