/*
 * Decompiled with CFR 0.152.
 */
package vuegwt.shaded.com.helger.commons.lang;

import java.io.PrintStream;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import vuegwt.shaded.com.helger.commons.annotation.ReturnsMutableCopy;
import vuegwt.shaded.com.helger.commons.collection.impl.CommonsArrayList;
import vuegwt.shaded.com.helger.commons.collection.impl.ICommonsList;
import vuegwt.shaded.com.helger.commons.string.StringHelper;
import vuegwt.shaded.com.helger.commons.system.ENewLineMode;
import vuegwt.shaded.com.helger.commons.system.SystemProperties;

@Immutable
public final class ClassPathHelper {
    private static final ClassPathHelper s_aInstance = new ClassPathHelper();

    private ClassPathHelper() {
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsList<String> getAllClassPathEntries() {
        CommonsArrayList<String> commonsArrayList = new CommonsArrayList<String>();
        ClassPathHelper.forAllClassPathEntries(commonsArrayList::add);
        return commonsArrayList;
    }

    public static void forAllClassPathEntries(@Nonnull Consumer<? super String> consumer) {
        StringHelper.explode(SystemProperties.getPathSeparator(), SystemProperties.getJavaClassPath(), consumer);
    }

    public static void printClassPathEntries(@Nonnull PrintStream printStream) {
        ClassPathHelper.printClassPathEntries(printStream, ENewLineMode.DEFAULT.getText());
    }

    public static void printClassPathEntries(@Nonnull PrintStream printStream, @Nonnull String string) {
        ClassPathHelper.forAllClassPathEntries(string2 -> {
            printStream.print((String)string2);
            printStream.print(string);
        });
    }
}

