/*
 * Decompiled with CFR 0.152.
 */
package vuegwt.shaded.com.helger.commons.lang;

import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.Immutable;
import vuegwt.shaded.com.helger.commons.ValueEnforcer;
import vuegwt.shaded.com.helger.commons.annotation.ReturnsMutableCopy;
import vuegwt.shaded.com.helger.commons.collection.ArrayHelper;
import vuegwt.shaded.com.helger.commons.collection.impl.CommonsArrayList;
import vuegwt.shaded.com.helger.commons.collection.impl.CommonsHashMap;
import vuegwt.shaded.com.helger.commons.collection.impl.ICommonsList;
import vuegwt.shaded.com.helger.commons.collection.impl.ICommonsMap;
import vuegwt.shaded.com.helger.commons.concurrent.SimpleReadWriteLock;
import vuegwt.shaded.com.helger.commons.id.IHasID;
import vuegwt.shaded.com.helger.commons.id.IHasIntID;
import vuegwt.shaded.com.helger.commons.lang.GenericReflection;
import vuegwt.shaded.com.helger.commons.name.IHasName;
import vuegwt.shaded.com.helger.commons.state.EChange;
import vuegwt.shaded.com.helger.commons.string.StringHelper;
import vuegwt.shaded.org.slf4j.Logger;
import vuegwt.shaded.org.slf4j.LoggerFactory;

@Immutable
public final class EnumHelper {
    private static final Logger s_aLogger = LoggerFactory.getLogger(EnumHelper.class);
    private static final Object[] NOT_CACHABLE = ArrayHelper.EMPTY_OBJECT_ARRAY;
    private static final SimpleReadWriteLock s_aRWLockInt = new SimpleReadWriteLock();
    @GuardedBy(value="s_aRWLockInt")
    private static final ICommonsMap<String, Object[]> s_aIntCache = new CommonsHashMap<String, Object[]>();
    private static final EnumHelper s_aInstance = new EnumHelper();

    private EnumHelper() {
    }

    @Nonnull
    public static <ENUMTYPE extends Enum<ENUMTYPE>> ENUMTYPE findFirst(@Nonnull Class<ENUMTYPE> clazz, @Nullable Predicate<? super ENUMTYPE> predicate) {
        return EnumHelper.findFirst(clazz, predicate, null);
    }

    @Nonnull
    public static <ENUMTYPE extends Enum<ENUMTYPE>> ENUMTYPE findFirst(@Nonnull Class<ENUMTYPE> clazz, @Nullable Predicate<? super ENUMTYPE> predicate, @Nullable ENUMTYPE ENUMTYPE) {
        return (ENUMTYPE)((Enum)ArrayHelper.findFirst(clazz.getEnumConstants(), predicate, ENUMTYPE));
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ENUMTYPE extends Enum<ENUMTYPE>> ICommonsList<ENUMTYPE> getAll(@Nonnull Class<ENUMTYPE> clazz, @Nullable Predicate<? super ENUMTYPE> predicate) {
        return CommonsArrayList.createFiltered(clazz.getEnumConstants(), predicate);
    }

    @Nullable
    public static <KEYTYPE, ENUMTYPE extends Enum<ENUMTYPE>> ENUMTYPE getFromIDOrNull(@Nonnull Class<ENUMTYPE> clazz, @Nullable KEYTYPE KEYTYPE) {
        return EnumHelper.getFromIDOrDefault(clazz, KEYTYPE, null);
    }

    @Nullable
    public static <KEYTYPE, ENUMTYPE extends Enum<ENUMTYPE>> ENUMTYPE getFromIDOrDefault(@Nonnull Class<ENUMTYPE> clazz, @Nullable KEYTYPE KEYTYPE, @Nullable ENUMTYPE ENUMTYPE) {
        ValueEnforcer.notNull(clazz, "Class");
        if (KEYTYPE == null) {
            return ENUMTYPE;
        }
        return (ENUMTYPE)EnumHelper.findFirst(clazz, enum_ -> ((IHasID)((Object)enum_)).getID().equals(KEYTYPE), ENUMTYPE);
    }

    @Nonnull
    public static <KEYTYPE, ENUMTYPE extends Enum<ENUMTYPE>> ENUMTYPE getFromIDOrThrow(@Nonnull Class<ENUMTYPE> clazz, @Nullable KEYTYPE KEYTYPE) {
        ENUMTYPE ENUMTYPE = EnumHelper.getFromIDOrNull(clazz, KEYTYPE);
        if (ENUMTYPE == null) {
            throw new IllegalArgumentException("Failed to resolve ID " + KEYTYPE + " within class " + clazz);
        }
        return ENUMTYPE;
    }

    @Nullable
    public static <ENUMTYPE extends Enum<ENUMTYPE>> ENUMTYPE getFromIDCaseInsensitiveOrNull(@Nonnull Class<ENUMTYPE> clazz, @Nullable String string) {
        return EnumHelper.getFromIDCaseInsensitiveOrDefault(clazz, string, null);
    }

    @Nullable
    public static <ENUMTYPE extends Enum<ENUMTYPE>> ENUMTYPE getFromIDCaseInsensitiveOrDefault(@Nonnull Class<ENUMTYPE> clazz, @Nullable String string, @Nullable ENUMTYPE ENUMTYPE) {
        ValueEnforcer.notNull(clazz, "Class");
        if (string == null) {
            return ENUMTYPE;
        }
        return (ENUMTYPE)EnumHelper.findFirst(clazz, enum_ -> ((String)((IHasID)((Object)enum_)).getID()).equalsIgnoreCase(string), ENUMTYPE);
    }

    @Nonnull
    public static <ENUMTYPE extends Enum<ENUMTYPE>> ENUMTYPE getFromIDCaseInsensitiveOrThrow(@Nonnull Class<ENUMTYPE> clazz, @Nullable String string) {
        ENUMTYPE ENUMTYPE = EnumHelper.getFromIDCaseInsensitiveOrNull(clazz, string);
        if (ENUMTYPE == null) {
            throw new IllegalArgumentException("Failed to resolve ID " + string + " within class " + clazz);
        }
        return ENUMTYPE;
    }

    @Nullable
    public static <ENUMTYPE extends Enum<ENUMTYPE>> ENUMTYPE getFromIDOrNull(@Nonnull Class<ENUMTYPE> clazz, int n) {
        return EnumHelper.getFromIDOrDefault(clazz, n, null);
    }

    @Nullable
    public static <ENUMTYPE extends Enum<ENUMTYPE>> ENUMTYPE getFromIDOrDefault(@Nonnull Class<ENUMTYPE> clazz, int n, @Nullable ENUMTYPE ENUMTYPE) {
        ValueEnforcer.notNull(clazz, "Class");
        String string = clazz.getName();
        Object[] objectArray = s_aRWLockInt.readLocked(() -> (Object[])s_aIntCache.get(string));
        if (objectArray == null) {
            objectArray = s_aRWLockInt.writeLocked(() -> {
                Object[] objectArray = (Object[])s_aIntCache.get(string);
                if (objectArray == null) {
                    int n = Integer.MAX_VALUE;
                    int n2 = Integer.MIN_VALUE;
                    for (Enum enum_ : (Enum[])clazz.getEnumConstants()) {
                        int n3 = ((IHasIntID)((Object)enum_)).getID();
                        if (n3 < n) {
                            n = n3;
                        }
                        if (n3 <= n2) continue;
                        n2 = n3;
                    }
                    if (n >= 0 && n2 <= 255) {
                        objectArray = new Object[n2 + 1];
                        for (Enum enum_ : (Enum[])clazz.getEnumConstants()) {
                            objectArray[((IHasIntID)((Object)enum_)).getID()] = enum_;
                        }
                    } else {
                        objectArray = NOT_CACHABLE;
                    }
                    s_aIntCache.put(string, objectArray);
                }
                return objectArray;
            });
        }
        if (objectArray != NOT_CACHABLE) {
            if (n < 0 || n >= objectArray.length) {
                return ENUMTYPE;
            }
            return (ENUMTYPE)((Enum)GenericReflection.uncheckedCast(objectArray[n]));
        }
        return (ENUMTYPE)EnumHelper.findFirst(clazz, enum_ -> ((IHasIntID)((Object)enum_)).getID() == n, ENUMTYPE);
    }

    @Nonnull
    public static <ENUMTYPE extends Enum<ENUMTYPE>> ENUMTYPE getFromIDOrThrow(@Nonnull Class<ENUMTYPE> clazz, int n) {
        ENUMTYPE ENUMTYPE = EnumHelper.getFromIDOrNull(clazz, n);
        if (ENUMTYPE == null) {
            throw new IllegalArgumentException("Failed to resolve ID " + n + " within class " + clazz);
        }
        return ENUMTYPE;
    }

    @Nullable
    public static <ENUMTYPE extends Enum<ENUMTYPE>> ENUMTYPE getFromNameOrNull(@Nonnull Class<ENUMTYPE> clazz, @Nullable String string) {
        return EnumHelper.getFromNameOrDefault(clazz, string, null);
    }

    @Nullable
    public static <ENUMTYPE extends Enum<ENUMTYPE>> ENUMTYPE getFromNameOrDefault(@Nonnull Class<ENUMTYPE> clazz, @Nullable String string, @Nullable ENUMTYPE ENUMTYPE) {
        ValueEnforcer.notNull(clazz, "Class");
        if (StringHelper.hasNoText(string)) {
            return ENUMTYPE;
        }
        return (ENUMTYPE)EnumHelper.findFirst(clazz, enum_ -> ((IHasName)((Object)enum_)).getName().equals(string), ENUMTYPE);
    }

    @Nonnull
    public static <ENUMTYPE extends Enum<ENUMTYPE>> ENUMTYPE getFromNameOrThrow(@Nonnull Class<ENUMTYPE> clazz, @Nullable String string) {
        ENUMTYPE ENUMTYPE = EnumHelper.getFromNameOrNull(clazz, string);
        if (ENUMTYPE == null) {
            throw new IllegalArgumentException("Failed to resolve name " + string + " within class " + clazz);
        }
        return ENUMTYPE;
    }

    @Nullable
    public static <ENUMTYPE extends Enum<ENUMTYPE>> ENUMTYPE getFromNameCaseInsensitiveOrNull(@Nonnull Class<ENUMTYPE> clazz, @Nullable String string) {
        return EnumHelper.getFromNameCaseInsensitiveOrDefault(clazz, string, null);
    }

    @Nullable
    public static <ENUMTYPE extends Enum<ENUMTYPE>> ENUMTYPE getFromNameCaseInsensitiveOrDefault(@Nonnull Class<ENUMTYPE> clazz, @Nullable String string, @Nullable ENUMTYPE ENUMTYPE) {
        ValueEnforcer.notNull(clazz, "Class");
        if (StringHelper.hasNoText(string)) {
            return ENUMTYPE;
        }
        return (ENUMTYPE)EnumHelper.findFirst(clazz, enum_ -> ((IHasName)((Object)enum_)).getName().equalsIgnoreCase(string), ENUMTYPE);
    }

    @Nonnull
    public static <ENUMTYPE extends Enum<ENUMTYPE>> ENUMTYPE getFromNameCaseInsensitiveOrThrow(@Nonnull Class<ENUMTYPE> clazz, @Nullable String string) {
        ENUMTYPE ENUMTYPE = EnumHelper.getFromNameCaseInsensitiveOrNull(clazz, string);
        if (ENUMTYPE == null) {
            throw new IllegalArgumentException("Failed to resolve name " + string + " within class " + clazz);
        }
        return ENUMTYPE;
    }

    @Nonnull
    public static String getEnumID(@Nonnull Enum<?> enum_) {
        return enum_.getClass().getName() + '.' + enum_.name();
    }

    @Nonnull
    public static EChange clearCache() {
        return s_aRWLockInt.writeLocked(() -> {
            if (s_aIntCache.isEmpty()) {
                return EChange.UNCHANGED;
            }
            s_aIntCache.clear();
            if (s_aLogger.isDebugEnabled()) {
                s_aLogger.debug("Cache was cleared: " + EnumHelper.class.getName());
            }
            return EChange.CHANGED;
        });
    }
}

