/*
 * Decompiled with CFR 0.152.
 */
package vuegwt.shaded.com.helger.commons.log;

import java.io.Serializable;
import java.util.Iterator;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import vuegwt.shaded.com.helger.commons.annotation.OverrideOnDemand;
import vuegwt.shaded.com.helger.commons.annotation.ReturnsMutableCopy;
import vuegwt.shaded.com.helger.commons.collection.impl.CommonsArrayList;
import vuegwt.shaded.com.helger.commons.collection.impl.ICommonsList;
import vuegwt.shaded.com.helger.commons.error.level.EErrorLevel;
import vuegwt.shaded.com.helger.commons.error.level.IErrorLevel;
import vuegwt.shaded.com.helger.commons.error.level.IHasErrorLevels;
import vuegwt.shaded.com.helger.commons.lang.IHasSize;
import vuegwt.shaded.com.helger.commons.log.LogMessage;
import vuegwt.shaded.com.helger.commons.state.EChange;
import vuegwt.shaded.com.helger.commons.state.IClearable;
import vuegwt.shaded.com.helger.commons.string.ToStringGenerator;

@NotThreadSafe
public class InMemoryLogger
implements IHasErrorLevels<LogMessage>,
IHasSize,
IClearable {
    private final ICommonsList<LogMessage> m_aMessages = new CommonsArrayList<LogMessage>();

    @Nullable
    @OverrideOnDemand
    protected LogMessage createLogMessage(@Nonnull IErrorLevel iErrorLevel, @Nonnull Serializable serializable, @Nullable Throwable throwable) {
        return new LogMessage(iErrorLevel, serializable, throwable);
    }

    @OverrideOnDemand
    protected void onAddLogMessage(@Nonnull LogMessage logMessage) {
    }

    public void log(@Nonnull IErrorLevel iErrorLevel, @Nonnull Serializable serializable) {
        this.log(iErrorLevel, serializable, null);
    }

    public void log(@Nonnull IErrorLevel iErrorLevel, @Nonnull Serializable serializable, @Nullable Throwable throwable) {
        LogMessage logMessage = this.createLogMessage(iErrorLevel, serializable, throwable);
        if (logMessage != null) {
            this.m_aMessages.add(logMessage);
            this.onAddLogMessage(logMessage);
        }
    }

    public void error(@Nonnull Serializable serializable) {
        this.error(serializable, null);
    }

    public void error(@Nonnull Serializable serializable, @Nullable Throwable throwable) {
        this.log(EErrorLevel.ERROR, serializable, throwable);
    }

    public void warn(@Nonnull Serializable serializable) {
        this.warn(serializable, null);
    }

    public void warn(@Nonnull Serializable serializable, @Nullable Throwable throwable) {
        this.log(EErrorLevel.WARN, serializable, throwable);
    }

    public void info(@Nonnull Serializable serializable) {
        this.log(EErrorLevel.INFO, serializable, null);
    }

    public void info(@Nonnull Serializable serializable, @Nullable Throwable throwable) {
        this.log(EErrorLevel.INFO, serializable, throwable);
    }

    public void success(@Nonnull Serializable serializable) {
        this.log(EErrorLevel.SUCCESS, serializable, null);
    }

    public void success(@Nonnull Serializable serializable, @Nullable Throwable throwable) {
        this.log(EErrorLevel.SUCCESS, serializable, throwable);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<LogMessage> getAllMessages() {
        return (ICommonsList)this.m_aMessages.getClone();
    }

    @Override
    @Nonnull
    public Iterator<LogMessage> iterator() {
        return this.m_aMessages.iterator();
    }

    @Override
    @Nonnegative
    public int size() {
        return this.m_aMessages.size();
    }

    @Override
    public boolean isEmpty() {
        return this.m_aMessages.isEmpty();
    }

    @Override
    @Nonnull
    public EChange removeAll() {
        return this.m_aMessages.removeAll();
    }

    public String toString() {
        return new ToStringGenerator(this).append("messages", this.m_aMessages).getToString();
    }
}

