/*
 * Decompiled with CFR 0.152.
 */
package vuegwt.shaded.com.helger.commons.log;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import vuegwt.shaded.com.helger.commons.ValueEnforcer;
import vuegwt.shaded.com.helger.commons.error.level.EErrorLevel;
import vuegwt.shaded.com.helger.commons.error.level.IErrorLevel;
import vuegwt.shaded.com.helger.commons.error.level.IHasErrorLevel;
import vuegwt.shaded.org.slf4j.Logger;
import vuegwt.shaded.org.slf4j.LoggerFactory;

@Immutable
public final class LogHelper {
    private static final LogHelper s_aInstance = new LogHelper();

    private LogHelper() {
    }

    public static boolean isEnabled(@Nonnull Class<?> clazz, @Nonnull IHasErrorLevel iHasErrorLevel) {
        return LogHelper.isEnabled(LoggerFactory.getLogger(clazz), iHasErrorLevel.getErrorLevel());
    }

    public static boolean isEnabled(@Nonnull Logger logger, @Nonnull IHasErrorLevel iHasErrorLevel) {
        return LogHelper.isEnabled(logger, iHasErrorLevel.getErrorLevel());
    }

    public static boolean isEnabled(@Nonnull Class<?> clazz, @Nonnull IErrorLevel iErrorLevel) {
        return LogHelper.isEnabled(LoggerFactory.getLogger(clazz), iErrorLevel);
    }

    public static boolean isEnabled(@Nonnull Logger logger, @Nonnull IErrorLevel iErrorLevel) {
        if (iErrorLevel.isGE(EErrorLevel.ERROR)) {
            return logger.isErrorEnabled();
        }
        if (iErrorLevel.isGE(EErrorLevel.WARN)) {
            return logger.isWarnEnabled();
        }
        if (iErrorLevel.isGE(EErrorLevel.INFO)) {
            return logger.isInfoEnabled();
        }
        return logger.isDebugEnabled();
    }

    public static void log(@Nonnull Class<?> clazz, @Nonnull IHasErrorLevel iHasErrorLevel, @Nonnull String string) {
        LogHelper.log(clazz, iHasErrorLevel.getErrorLevel(), string, null);
    }

    public static void log(@Nonnull Class<?> clazz, @Nonnull IHasErrorLevel iHasErrorLevel, @Nonnull String string, @Nullable Throwable throwable) {
        LogHelper.log(LoggerFactory.getLogger(clazz), iHasErrorLevel.getErrorLevel(), string, throwable);
    }

    public static void log(@Nonnull Logger logger, @Nonnull IHasErrorLevel iHasErrorLevel, @Nonnull String string) {
        LogHelper.log(logger, iHasErrorLevel.getErrorLevel(), string, null);
    }

    public static void log(@Nonnull Logger logger, @Nonnull IHasErrorLevel iHasErrorLevel, @Nonnull String string, @Nullable Throwable throwable) {
        LogHelper.log(logger, iHasErrorLevel.getErrorLevel(), string, throwable);
    }

    public static void log(@Nonnull Class<?> clazz, @Nonnull IErrorLevel iErrorLevel, @Nonnull String string) {
        LogHelper.log(clazz, iErrorLevel, string, null);
    }

    public static void log(@Nonnull Class<?> clazz, @Nonnull IErrorLevel iErrorLevel, @Nonnull String string, @Nullable Throwable throwable) {
        LogHelper.log(LoggerFactory.getLogger(clazz), iErrorLevel, string, throwable);
    }

    public static void log(@Nonnull Logger logger, @Nonnull IErrorLevel iErrorLevel, @Nonnull String string) {
        LogHelper.log(logger, iErrorLevel, string, null);
    }

    public static void log(@Nonnull Logger logger, @Nonnull IErrorLevel iErrorLevel, @Nonnull String string, @Nullable Throwable throwable) {
        ValueEnforcer.notNull(logger, "Logger");
        ValueEnforcer.notNull(iErrorLevel, "ErrorLevel");
        ValueEnforcer.notNull(string, "Message");
        if (iErrorLevel.isGE(EErrorLevel.ERROR)) {
            logger.error(string, throwable);
        } else if (iErrorLevel.isGE(EErrorLevel.WARN)) {
            logger.warn(string, throwable);
        } else if (iErrorLevel.isGE(EErrorLevel.INFO)) {
            logger.info(string, throwable);
        } else if (logger.isDebugEnabled()) {
            logger.debug(string, throwable);
        }
    }
}

