/*
 * Decompiled with CFR 0.152.
 */
package vuegwt.shaded.com.helger.commons.math;

import java.math.BigInteger;
import java.util.Collection;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import vuegwt.shaded.com.helger.commons.CGlobal;
import vuegwt.shaded.com.helger.commons.ValueEnforcer;
import vuegwt.shaded.com.helger.commons.annotation.Nonempty;
import vuegwt.shaded.com.helger.commons.annotation.ReturnsMutableCopy;
import vuegwt.shaded.com.helger.commons.collection.impl.CommonsArrayList;
import vuegwt.shaded.com.helger.commons.collection.impl.ICommonsList;
import vuegwt.shaded.com.helger.commons.collection.iterate.IIterableIterator;
import vuegwt.shaded.com.helger.commons.lang.GenericReflection;
import vuegwt.shaded.com.helger.commons.math.FactorialHelper;

public class CombinationGenerator<DATATYPE>
implements IIterableIterator<ICommonsList<DATATYPE>> {
    private final DATATYPE[] m_aElements;
    private final int[] m_aIndexResult;
    private final BigInteger m_aTotalCombinations;
    private BigInteger m_aCombinationsLeft;
    private final boolean m_bUseLong;
    private final long m_nTotalCombinations;
    private long m_nCombinationsLeft;

    public CombinationGenerator(@Nonnull @Nonempty ICommonsList<DATATYPE> iCommonsList, @Nonnegative int n) {
        ValueEnforcer.notEmpty(iCommonsList, "Elements");
        ValueEnforcer.isBetweenInclusive(n, "SlotCount", 0, iCommonsList.size());
        this.m_aElements = (Object[])GenericReflection.uncheckedCast(iCommonsList.toArray());
        this.m_aIndexResult = new int[n];
        BigInteger bigInteger = FactorialHelper.getAnyFactorialLinear(this.m_aElements.length);
        BigInteger bigInteger2 = FactorialHelper.getAnyFactorialLinear(n);
        BigInteger bigInteger3 = FactorialHelper.getAnyFactorialLinear(this.m_aElements.length - n);
        this.m_aTotalCombinations = bigInteger.divide(bigInteger2.multiply(bigInteger3));
        this.m_bUseLong = this.m_aTotalCombinations.compareTo(CGlobal.BIGINT_MAX_LONG) < 0;
        this.m_nTotalCombinations = this.m_bUseLong ? this.m_aTotalCombinations.longValue() : -1L;
        this.reset();
    }

    public final void reset() {
        for (int i = 0; i < this.m_aIndexResult.length; ++i) {
            this.m_aIndexResult[i] = i;
        }
        this.m_aCombinationsLeft = this.m_aTotalCombinations;
        this.m_nCombinationsLeft = this.m_nTotalCombinations;
    }

    @Nonnull
    public BigInteger getCombinationsLeft() {
        return this.m_bUseLong ? BigInteger.valueOf(this.m_nCombinationsLeft) : this.m_aCombinationsLeft;
    }

    @Override
    public boolean hasNext() {
        return this.m_bUseLong ? this.m_nCombinationsLeft > 0L : this.m_aCombinationsLeft.compareTo(BigInteger.ZERO) > 0;
    }

    @Nonnull
    public BigInteger getTotalCombinations() {
        return this.m_aTotalCombinations;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<DATATYPE> next() {
        boolean bl;
        boolean bl2 = this.m_bUseLong ? this.m_nCombinationsLeft == this.m_nTotalCombinations : (bl = this.m_aCombinationsLeft.equals(this.m_aTotalCombinations));
        if (!bl) {
            int n = this.m_aElements.length;
            int n2 = this.m_aIndexResult.length;
            int n3 = n2 - 1;
            while (this.m_aIndexResult[n3] == n - n2 + n3) {
                --n3;
            }
            int n4 = n3;
            this.m_aIndexResult[n4] = this.m_aIndexResult[n4] + 1;
            int n5 = this.m_aIndexResult[n3];
            for (int i = n3 + 1; i < n2; ++i) {
                this.m_aIndexResult[i] = n5 + i - n3;
            }
        }
        if (this.m_bUseLong) {
            --this.m_nCombinationsLeft;
        } else {
            this.m_aCombinationsLeft = this.m_aCombinationsLeft.subtract(BigInteger.ONE);
        }
        CommonsArrayList<int> commonsArrayList = new CommonsArrayList<int>(this.m_aIndexResult.length);
        for (int i : this.m_aIndexResult) {
            commonsArrayList.add(this.m_aElements[i]);
        }
        return commonsArrayList;
    }

    @Nonnull
    public static <DATATYPE> ICommonsList<ICommonsList<DATATYPE>> getAllPermutations(@Nonnull @Nonempty ICommonsList<DATATYPE> iCommonsList, @Nonnegative int n) {
        CommonsArrayList<ICommonsList<DATATYPE>> commonsArrayList = new CommonsArrayList<ICommonsList<DATATYPE>>();
        CombinationGenerator.addAllPermutations(iCommonsList, n, commonsArrayList);
        return commonsArrayList;
    }

    public static <DATATYPE> void addAllPermutations(@Nonnull @Nonempty ICommonsList<DATATYPE> iCommonsList, @Nonnegative int n, @Nonnull Collection<ICommonsList<DATATYPE>> collection) {
        for (ICommonsList iCommonsList2 : new CombinationGenerator<DATATYPE>(iCommonsList, n)) {
            collection.add(iCommonsList2);
        }
    }
}

