/*
 * Decompiled with CFR 0.152.
 */
package vuegwt.shaded.com.helger.commons.math;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import vuegwt.shaded.com.helger.commons.CGlobal;
import vuegwt.shaded.com.helger.commons.ValueEnforcer;
import vuegwt.shaded.com.helger.commons.equals.EqualsHelper;

@Immutable
public final class MathHelper {
    private static final long LONG_HIGH_BITS = Integer.MIN_VALUE;
    private static final MathHelper s_aInstance = new MathHelper();

    private MathHelper() {
    }

    public static int getRoundedUp(int n, @Nonnegative int n2) {
        if (n2 == 0) {
            return n;
        }
        int n3 = n % n2;
        if (n3 == 0) {
            return n;
        }
        if (n < 0) {
            return -MathHelper.abs(n - n3);
        }
        return n + n2 - n3;
    }

    public static double getDividedDouble(int n, int n2) {
        double d = n;
        double d2 = n2;
        return d / d2;
    }

    public static double getDividedDouble(long l, long l2) {
        double d = l;
        double d2 = l2;
        return d / d2;
    }

    @Nonnull
    public static BigDecimal getDividedBigDecimal(long l, long l2) throws ArithmeticException {
        BigDecimal bigDecimal = BigDecimal.valueOf(l);
        BigDecimal bigDecimal2 = BigDecimal.valueOf(l2);
        return bigDecimal.divide(bigDecimal2);
    }

    public static int getIntDividedCeil(int n, int n2) {
        return MathHelper.getIntDivided(n, n2, RoundingMode.CEILING);
    }

    public static int getIntDividedFloor(int n, int n2) {
        return MathHelper.getIntDivided(n, n2, RoundingMode.FLOOR);
    }

    public static int getIntDivided(int n, int n2, @Nonnull RoundingMode roundingMode) {
        return MathHelper.toBigDecimal(n).divide(MathHelper.toBigDecimal(n2), roundingMode).intValue();
    }

    public static long getLongDividedCeil(long l, long l2) {
        return MathHelper.getLongDivided(l, l2, RoundingMode.CEILING);
    }

    public static long getLongDividedFloor(long l, long l2) {
        return MathHelper.getLongDivided(l, l2, RoundingMode.FLOOR);
    }

    public static long getLongDivided(long l, long l2, @Nonnull RoundingMode roundingMode) {
        return MathHelper.toBigDecimal(l).divide(MathHelper.toBigDecimal(l2), roundingMode).longValue();
    }

    public static boolean canConvertLongToInt(long l) {
        return (l & Integer.MIN_VALUE) == 0L || (l & Integer.MIN_VALUE) == Integer.MIN_VALUE;
    }

    @CheckReturnValue
    public static int getLongAsInt(long l, int n) {
        return MathHelper.canConvertLongToInt(l) ? (int)l : n;
    }

    public static int getMaxInt(int n, int ... nArray) {
        int n2 = n;
        for (int n3 : nArray) {
            n2 = Math.max(n2, n3);
        }
        return n2;
    }

    public static long getMaxLong(long l, long ... lArray) {
        long l2 = l;
        for (long l3 : lArray) {
            l2 = Math.max(l2, l3);
        }
        return l2;
    }

    public static double getMaxFloat(float f, float ... fArray) {
        float f2 = f;
        for (float f3 : fArray) {
            f2 = Math.max(f2, f3);
        }
        return f2;
    }

    public static double getMaxDouble(double d, double ... dArray) {
        double d2 = d;
        for (double d3 : dArray) {
            d2 = Math.max(d2, d3);
        }
        return d2;
    }

    @Nonnull
    public static BigDecimal getMaxBigDecimal(@Nonnull BigDecimal bigDecimal, BigDecimal ... bigDecimalArray) {
        BigDecimal bigDecimal2 = bigDecimal;
        for (BigDecimal bigDecimal3 : bigDecimalArray) {
            if (bigDecimal3.compareTo(bigDecimal2) <= 0) continue;
            bigDecimal2 = bigDecimal3;
        }
        return bigDecimal2;
    }

    @Nonnull
    public static BigInteger getMaxBigInteger(@Nonnull BigInteger bigInteger, BigInteger ... bigIntegerArray) {
        BigInteger bigInteger2 = bigInteger;
        for (BigInteger bigInteger3 : bigIntegerArray) {
            if (bigInteger3.compareTo(bigInteger2) <= 0) continue;
            bigInteger2 = bigInteger3;
        }
        return bigInteger2;
    }

    public static int getMinInt(int n, int ... nArray) {
        int n2 = n;
        for (int n3 : nArray) {
            n2 = Math.min(n2, n3);
        }
        return n2;
    }

    public static long getMinLong(long l, long ... lArray) {
        long l2 = l;
        for (long l3 : lArray) {
            l2 = Math.min(l2, l3);
        }
        return l2;
    }

    public static double getMinFloat(float f, float ... fArray) {
        float f2 = f;
        for (float f3 : fArray) {
            f2 = Math.min(f2, f3);
        }
        return f2;
    }

    public static double getMinDouble(double d, double ... dArray) {
        double d2 = d;
        for (double d3 : dArray) {
            d2 = Math.min(d2, d3);
        }
        return d2;
    }

    @Nonnull
    public static BigDecimal getMinBigDecimal(@Nonnull BigDecimal bigDecimal, BigDecimal ... bigDecimalArray) {
        BigDecimal bigDecimal2 = bigDecimal;
        for (BigDecimal bigDecimal3 : bigDecimalArray) {
            if (bigDecimal3.compareTo(bigDecimal2) >= 0) continue;
            bigDecimal2 = bigDecimal3;
        }
        return bigDecimal2;
    }

    @Nonnull
    public static BigInteger getMinBigInteger(@Nonnull BigInteger bigInteger, BigInteger ... bigIntegerArray) {
        BigInteger bigInteger2 = bigInteger;
        for (BigInteger bigInteger3 : bigIntegerArray) {
            if (bigInteger3.compareTo(bigInteger2) >= 0) continue;
            bigInteger2 = bigInteger3;
        }
        return bigInteger2;
    }

    @Nonnegative
    public static int abs(int n) {
        if (n == Integer.MIN_VALUE) {
            throw new IllegalArgumentException("There is not absolute value for Integer.MIN_VALUE!");
        }
        return Math.abs(n);
    }

    @Nonnegative
    public static long abs(long l) {
        if (l == Long.MIN_VALUE) {
            throw new IllegalArgumentException("There is not absolute value for Long.MIN_VALUE!");
        }
        return Math.abs(l);
    }

    @Nonnegative
    public static float abs(float f) {
        return Math.abs(f);
    }

    @Nonnegative
    public static double abs(double d) {
        return Math.abs(d);
    }

    @Nonnull
    public static BigDecimal abs(@Nonnull BigDecimal bigDecimal) {
        return bigDecimal.abs();
    }

    @Nonnull
    public static BigInteger abs(@Nonnull BigInteger bigInteger) {
        return bigInteger.abs();
    }

    public static boolean isEQ0(@Nonnull BigDecimal bigDecimal) {
        return EqualsHelper.equals(bigDecimal, BigDecimal.ZERO);
    }

    public static boolean isNE0(@Nonnull BigDecimal bigDecimal) {
        return !EqualsHelper.equals(bigDecimal, BigDecimal.ZERO);
    }

    public static boolean isLT0(@Nonnull BigDecimal bigDecimal) {
        return bigDecimal.compareTo(BigDecimal.ZERO) < 0;
    }

    public static boolean isLE0(@Nonnull BigDecimal bigDecimal) {
        return bigDecimal.compareTo(BigDecimal.ZERO) <= 0;
    }

    public static boolean isGT0(@Nonnull BigDecimal bigDecimal) {
        return bigDecimal.compareTo(BigDecimal.ZERO) > 0;
    }

    public static boolean isGE0(@Nonnull BigDecimal bigDecimal) {
        return bigDecimal.compareTo(BigDecimal.ZERO) >= 0;
    }

    public static boolean isEQ1(@Nonnull BigDecimal bigDecimal) {
        return EqualsHelper.equals(bigDecimal, BigDecimal.ONE);
    }

    public static boolean isNE1(@Nonnull BigDecimal bigDecimal) {
        return !EqualsHelper.equals(bigDecimal, BigDecimal.ONE);
    }

    public static boolean isLT1(@Nonnull BigDecimal bigDecimal) {
        return bigDecimal.compareTo(BigDecimal.ONE) < 0;
    }

    public static boolean isLE1(@Nonnull BigDecimal bigDecimal) {
        return bigDecimal.compareTo(BigDecimal.ONE) <= 0;
    }

    public static boolean isGT1(@Nonnull BigDecimal bigDecimal) {
        return bigDecimal.compareTo(BigDecimal.ONE) > 0;
    }

    public static boolean isGE1(@Nonnull BigDecimal bigDecimal) {
        return bigDecimal.compareTo(BigDecimal.ONE) >= 0;
    }

    public static boolean isEQ10(@Nonnull BigDecimal bigDecimal) {
        return EqualsHelper.equals(bigDecimal, BigDecimal.TEN);
    }

    public static boolean isNE10(@Nonnull BigDecimal bigDecimal) {
        return !EqualsHelper.equals(bigDecimal, BigDecimal.TEN);
    }

    public static boolean isLT10(@Nonnull BigDecimal bigDecimal) {
        return bigDecimal.compareTo(BigDecimal.TEN) < 0;
    }

    public static boolean isLE10(@Nonnull BigDecimal bigDecimal) {
        return bigDecimal.compareTo(BigDecimal.TEN) <= 0;
    }

    public static boolean isGT10(@Nonnull BigDecimal bigDecimal) {
        return bigDecimal.compareTo(BigDecimal.TEN) > 0;
    }

    public static boolean isGE10(@Nonnull BigDecimal bigDecimal) {
        return bigDecimal.compareTo(BigDecimal.TEN) >= 0;
    }

    public static boolean isEQ100(@Nonnull BigDecimal bigDecimal) {
        return EqualsHelper.equals(bigDecimal, CGlobal.BIGDEC_100);
    }

    public static boolean isNE100(@Nonnull BigDecimal bigDecimal) {
        return !EqualsHelper.equals(bigDecimal, CGlobal.BIGDEC_100);
    }

    public static boolean isLT100(@Nonnull BigDecimal bigDecimal) {
        return bigDecimal.compareTo(CGlobal.BIGDEC_100) < 0;
    }

    public static boolean isLE100(@Nonnull BigDecimal bigDecimal) {
        return bigDecimal.compareTo(CGlobal.BIGDEC_100) <= 0;
    }

    public static boolean isGT100(@Nonnull BigDecimal bigDecimal) {
        return bigDecimal.compareTo(CGlobal.BIGDEC_100) > 0;
    }

    public static boolean isGE100(@Nonnull BigDecimal bigDecimal) {
        return bigDecimal.compareTo(CGlobal.BIGDEC_100) >= 0;
    }

    public static boolean isEQ0(@Nonnull BigInteger bigInteger) {
        return EqualsHelper.equals(bigInteger, BigInteger.ZERO);
    }

    public static boolean isNE0(@Nonnull BigInteger bigInteger) {
        return !EqualsHelper.equals(bigInteger, BigInteger.ZERO);
    }

    public static boolean isLT0(@Nonnull BigInteger bigInteger) {
        return bigInteger.compareTo(BigInteger.ZERO) < 0;
    }

    public static boolean isLE0(@Nonnull BigInteger bigInteger) {
        return bigInteger.compareTo(BigInteger.ZERO) <= 0;
    }

    public static boolean isGT0(@Nonnull BigInteger bigInteger) {
        return bigInteger.compareTo(BigInteger.ZERO) > 0;
    }

    public static boolean isGE0(@Nonnull BigInteger bigInteger) {
        return bigInteger.compareTo(BigInteger.ZERO) >= 0;
    }

    public static boolean isEQ1(@Nonnull BigInteger bigInteger) {
        return EqualsHelper.equals(bigInteger, BigInteger.ONE);
    }

    public static boolean isNE1(@Nonnull BigInteger bigInteger) {
        return !EqualsHelper.equals(bigInteger, BigInteger.ONE);
    }

    public static boolean isLT1(@Nonnull BigInteger bigInteger) {
        return bigInteger.compareTo(BigInteger.ONE) < 0;
    }

    public static boolean isLE1(@Nonnull BigInteger bigInteger) {
        return bigInteger.compareTo(BigInteger.ONE) <= 0;
    }

    public static boolean isGT1(@Nonnull BigInteger bigInteger) {
        return bigInteger.compareTo(BigInteger.ONE) > 0;
    }

    public static boolean isGE1(@Nonnull BigInteger bigInteger) {
        return bigInteger.compareTo(BigInteger.ONE) >= 0;
    }

    public static boolean isEQ10(@Nonnull BigInteger bigInteger) {
        return EqualsHelper.equals(bigInteger, BigInteger.TEN);
    }

    public static boolean isNE10(@Nonnull BigInteger bigInteger) {
        return !EqualsHelper.equals(bigInteger, BigInteger.TEN);
    }

    public static boolean isLT10(@Nonnull BigInteger bigInteger) {
        return bigInteger.compareTo(BigInteger.TEN) < 0;
    }

    public static boolean isLE10(@Nonnull BigInteger bigInteger) {
        return bigInteger.compareTo(BigInteger.TEN) <= 0;
    }

    public static boolean isGT10(@Nonnull BigInteger bigInteger) {
        return bigInteger.compareTo(BigInteger.TEN) > 0;
    }

    public static boolean isGE10(@Nonnull BigInteger bigInteger) {
        return bigInteger.compareTo(BigInteger.TEN) >= 0;
    }

    public static boolean isEQ100(@Nonnull BigInteger bigInteger) {
        return EqualsHelper.equals(bigInteger, CGlobal.BIGINT_100);
    }

    public static boolean isNE100(@Nonnull BigInteger bigInteger) {
        return !EqualsHelper.equals(bigInteger, CGlobal.BIGINT_100);
    }

    public static boolean isLT100(@Nonnull BigInteger bigInteger) {
        return bigInteger.compareTo(CGlobal.BIGINT_100) < 0;
    }

    public static boolean isLE100(@Nonnull BigInteger bigInteger) {
        return bigInteger.compareTo(CGlobal.BIGINT_100) <= 0;
    }

    public static boolean isGT100(@Nonnull BigInteger bigInteger) {
        return bigInteger.compareTo(CGlobal.BIGINT_100) > 0;
    }

    public static boolean isGE100(@Nonnull BigInteger bigInteger) {
        return bigInteger.compareTo(CGlobal.BIGINT_100) >= 0;
    }

    @Nullable
    @CheckReturnValue
    public static BigDecimal getWithoutTrailingZeroes(@Nullable String string) {
        if (string == null) {
            return null;
        }
        return MathHelper.getWithoutTrailingZeroes(new BigDecimal(string));
    }

    @Nullable
    @CheckReturnValue
    public static BigDecimal getWithoutTrailingZeroes(@Nullable BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            return null;
        }
        if (BigDecimal.ZERO.compareTo(bigDecimal) == 0) {
            return BigDecimal.ZERO;
        }
        BigDecimal bigDecimal2 = bigDecimal.stripTrailingZeros();
        return bigDecimal2.scale() >= 0 ? bigDecimal2 : bigDecimal2.setScale(0);
    }

    @Nonnegative
    public static int getFractionDigits(@Nonnull BigDecimal bigDecimal) {
        return MathHelper.getWithoutTrailingZeroes(bigDecimal).scale();
    }

    @Nonnull
    public static BigDecimal addPercent(@Nonnull BigDecimal bigDecimal, @Nonnull BigDecimal bigDecimal2) {
        return bigDecimal.multiply(CGlobal.BIGDEC_100.add(bigDecimal2)).divide(CGlobal.BIGDEC_100);
    }

    @Nonnull
    public static BigDecimal addPercent(@Nonnull BigDecimal bigDecimal, @Nonnull BigDecimal bigDecimal2, @Nonnegative int n, @Nonnull RoundingMode roundingMode) {
        return bigDecimal.multiply(CGlobal.BIGDEC_100.add(bigDecimal2)).divide(CGlobal.BIGDEC_100, n, roundingMode);
    }

    @Nonnull
    public static BigDecimal subtractPercent(@Nonnull BigDecimal bigDecimal, @Nonnull BigDecimal bigDecimal2) {
        return bigDecimal.multiply(CGlobal.BIGDEC_100.subtract(bigDecimal2)).divide(CGlobal.BIGDEC_100);
    }

    @Nonnull
    public static BigDecimal subtractPercent(@Nonnull BigDecimal bigDecimal, @Nonnull BigDecimal bigDecimal2, @Nonnegative int n, @Nonnull RoundingMode roundingMode) {
        return bigDecimal.multiply(CGlobal.BIGDEC_100.subtract(bigDecimal2)).divide(CGlobal.BIGDEC_100, n, roundingMode);
    }

    @Nonnull
    public static BigDecimal getPercentValue(@Nonnull BigDecimal bigDecimal, @Nonnull BigDecimal bigDecimal2) {
        return bigDecimal.multiply(bigDecimal2).divide(CGlobal.BIGDEC_100);
    }

    @Nonnull
    public static BigDecimal getPercentValue(@Nonnull BigDecimal bigDecimal, @Nonnull BigDecimal bigDecimal2, @Nonnegative int n, @Nonnull RoundingMode roundingMode) {
        return bigDecimal.multiply(bigDecimal2).divide(CGlobal.BIGDEC_100, n, roundingMode);
    }

    public static double hypot(double d, double d2) {
        double d3;
        double d4;
        if (d == 0.0) {
            return d2;
        }
        if (d2 == 0.0) {
            return d;
        }
        double d5 = MathHelper.abs(d);
        if (d5 > (d4 = MathHelper.abs(d2))) {
            d3 = d2 / d;
            d3 = d5 * Math.sqrt(1.0 + d3 * d3);
        } else {
            d3 = d / d2;
            d3 = d4 * Math.sqrt(1.0 + d3 * d3);
        }
        return d3;
    }

    public static long getUnsignedInt(int n) {
        return (long)n & 0xFFFFFFFFL;
    }

    @Nonnull
    public static BigDecimal toBigDecimal(int n) {
        return BigDecimal.valueOf(n);
    }

    @Nonnull
    public static BigDecimal toBigDecimal(long l) {
        return BigDecimal.valueOf(l);
    }

    @Nonnull
    public static BigDecimal toBigDecimal(float f) {
        return BigDecimal.valueOf(f);
    }

    @Nonnull
    public static BigDecimal toBigDecimal(double d) {
        return BigDecimal.valueOf(d);
    }

    @Nonnull
    public static BigDecimal toBigDecimal(@Nonnull Number number) {
        ValueEnforcer.notNull(number, "Number");
        return new BigDecimal(number.toString());
    }

    @Nonnull
    public static BigDecimal toBigDecimal(@Nonnull String string) {
        ValueEnforcer.notNull(string, "Number");
        return new BigDecimal(string);
    }

    @Nonnull
    public static BigInteger toBigInteger(int n) {
        return BigInteger.valueOf(n);
    }

    @Nonnull
    public static BigInteger toBigInteger(long l) {
        return BigInteger.valueOf(l);
    }

    @Nonnull
    public static BigInteger toBigInteger(@Nonnull Number number) {
        ValueEnforcer.notNull(number, "Number");
        return new BigInteger(number.toString());
    }

    @Nonnull
    public static BigInteger toBigInteger(@Nonnull String string) {
        ValueEnforcer.notNull(string, "Number");
        return new BigInteger(string);
    }

    public static boolean isExactlyOneBitSetToOne(int n) {
        return n != 0 && (n & n - 1) == 0;
    }

    public static boolean isExactlyOneBitSetToOne(long l) {
        return l != 0L && (l & l - 1L) == 0L;
    }
}

