/*
 * Decompiled with CFR 0.152.
 */
package vuegwt.shaded.com.helger.commons.random;

import java.security.SecureRandom;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import vuegwt.shaded.com.helger.commons.random.VerySecureRandom;

@Immutable
public final class RandomHelper {
    private static final AtomicBoolean s_aUseSecureRandom = new AtomicBoolean(true);

    private RandomHelper() {
    }

    public static void setUseSecureRandom(boolean bl) {
        s_aUseSecureRandom.set(bl);
    }

    public static boolean isUseSecureRandom() {
        return s_aUseSecureRandom.get();
    }

    @Nonnull
    public static Random getRandom() {
        if (RandomHelper.isUseSecureRandom()) {
            return VerySecureRandom.getInstance();
        }
        return new Random();
    }

    @Nullable
    public static SecureRandom getSecureRandom() {
        if (RandomHelper.isUseSecureRandom()) {
            return VerySecureRandom.getInstance();
        }
        return null;
    }
}

