/*
 * Decompiled with CFR 0.152.
 */
package vuegwt.shaded.com.helger.commons.regex;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.RegEx;
import javax.annotation.concurrent.Immutable;
import vuegwt.shaded.com.helger.commons.ValueEnforcer;
import vuegwt.shaded.com.helger.commons.collection.ArrayHelper;
import vuegwt.shaded.com.helger.commons.collection.impl.CommonsArrayList;
import vuegwt.shaded.com.helger.commons.collection.impl.ICommonsList;
import vuegwt.shaded.com.helger.commons.regex.RegExCache;
import vuegwt.shaded.com.helger.commons.string.StringHelper;

@Immutable
public final class RegExHelper {
    private static final RegExHelper s_aInstance = new RegExHelper();

    private RegExHelper() {
    }

    @Nonnull
    public static String[] getSplitToArray(@Nullable CharSequence charSequence, @Nonnull @RegEx String string) {
        if (charSequence == null) {
            return ArrayHelper.EMPTY_STRING_ARRAY;
        }
        return RegExCache.getPattern(string).split(charSequence);
    }

    @Nonnull
    public static String[] getSplitToArray(@Nullable CharSequence charSequence, @Nonnull @RegEx String string, @Nonnegative int n) {
        ValueEnforcer.notNull(string, "RegEx");
        if (charSequence == null) {
            return ArrayHelper.EMPTY_STRING_ARRAY;
        }
        return RegExCache.getPattern(string).split(charSequence, n);
    }

    @Nonnull
    public static ICommonsList<String> getSplitToList(@Nullable CharSequence charSequence, @Nonnull @RegEx String string) {
        return new CommonsArrayList<String>(RegExHelper.getSplitToArray(charSequence, string));
    }

    @Nonnull
    public static ICommonsList<String> getSplitToList(@Nullable CharSequence charSequence, @Nonnull @RegEx String string, @Nonnegative int n) {
        return new CommonsArrayList<String>(RegExHelper.getSplitToArray(charSequence, string, n));
    }

    @Nonnull
    public static Matcher getMatcher(@Nonnull @RegEx String string, @Nonnull String string2) {
        ValueEnforcer.notNull(string2, "Value");
        return RegExCache.getPattern(string).matcher(string2);
    }

    @Nonnull
    public static Matcher getMatcher(@Nonnull @RegEx String string, @Nonnegative int n, @Nonnull String string2) {
        ValueEnforcer.notNull(string2, "Value");
        return RegExCache.getPattern(string, n).matcher(string2);
    }

    public static boolean stringMatchesPattern(@Nonnull @RegEx String string, @Nonnull String string2) {
        return RegExHelper.getMatcher(string, string2).matches();
    }

    public static boolean stringMatchesPattern(@Nonnull @RegEx String string, @Nonnegative int n, @Nonnull String string2) {
        return RegExHelper.getMatcher(string, n, string2).matches();
    }

    @Nonnull
    public static String stringReplacePattern(@Nonnull @RegEx String string, @Nonnull String string2, @Nullable String string3) {
        return RegExHelper.getMatcher(string, string2).replaceAll(StringHelper.getNotNull(string3));
    }

    @Nonnull
    public static String stringReplacePattern(@Nonnull @RegEx String string, @Nonnegative int n, @Nonnull String string2, @Nullable String string3) {
        return RegExHelper.getMatcher(string, n, string2).replaceAll(StringHelper.getNotNull(string3));
    }

    @Nullable
    public static String getAsIdentifier(@Nullable String string) {
        return RegExHelper.getAsIdentifier(string, "_");
    }

    @Nullable
    public static String getAsIdentifier(@Nullable String string, char c) {
        if (StringHelper.hasNoText(string)) {
            return string;
        }
        String string2 = c == '$' || c == '\\' ? "\\" + c : Character.toString(c);
        String string3 = RegExHelper.stringReplacePattern("\\W", string, string2);
        if (!Character.isJavaIdentifierStart(string3.charAt(0))) {
            return string2 + string3;
        }
        return string3;
    }

    @Nullable
    public static String getAsIdentifier(@Nullable String string, @Nonnull String string2) {
        ValueEnforcer.notNull(string2, "Replacement");
        if (StringHelper.hasNoText(string)) {
            return string;
        }
        String string3 = RegExHelper.stringReplacePattern("\\W", string, string2);
        if (string3.length() == 0) {
            return string2;
        }
        if (!Character.isJavaIdentifierStart(string3.charAt(0))) {
            return string2 + string3;
        }
        return string3;
    }

    public static boolean isValidPattern(@Nonnull @RegEx String string) {
        try {
            Pattern.compile(string);
            return true;
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return false;
        }
    }

    @Nullable
    public static String[] getAllMatchingGroupValues(@Nonnull @RegEx String string, @Nonnull String string2) {
        Matcher matcher = RegExHelper.getMatcher(string, string2);
        if (!matcher.find()) {
            return null;
        }
        int n = matcher.groupCount();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = matcher.group(i + 1);
        }
        return stringArray;
    }
}

