/*
 * Decompiled with CFR 0.152.
 */
package vuegwt.shaded.com.helger.commons.serialize.convert;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import vuegwt.shaded.com.helger.commons.ValueEnforcer;
import vuegwt.shaded.com.helger.commons.lang.GenericReflection;
import vuegwt.shaded.com.helger.commons.serialize.convert.ISerializationConverter;
import vuegwt.shaded.com.helger.commons.serialize.convert.SerializationConverterRegistry;
import vuegwt.shaded.com.helger.commons.typeconvert.TypeConverterException;

@ThreadSafe
public final class SerializationConverter {
    private static final SerializationConverter s_aInstance = new SerializationConverter();

    private SerializationConverter() {
    }

    public static <T> void writeConvertedObject(@Nullable T t, @Nonnull ObjectOutputStream objectOutputStream) throws TypeConverterException, IOException {
        ValueEnforcer.notNull(objectOutputStream, "ObjectOutputStream");
        objectOutputStream.writeBoolean(t == null);
        if (t != null) {
            Class clazz = (Class)GenericReflection.uncheckedCast(t.getClass());
            ISerializationConverter<T> iSerializationConverter = SerializationConverterRegistry.getInstance().getConverter(clazz);
            if (iSerializationConverter == null) {
                throw new TypeConverterException(clazz, TypeConverterException.EReason.NO_CONVERTER_FOUND_SINGLE);
            }
            iSerializationConverter.writeConvertedObject(t, objectOutputStream);
        }
    }

    @Nullable
    public static <DSTTYPE> DSTTYPE readConvertedObject(@Nonnull ObjectInputStream objectInputStream, @Nonnull Class<DSTTYPE> clazz) throws TypeConverterException, IOException {
        ValueEnforcer.notNull(objectInputStream, "ObjectInputStream");
        ValueEnforcer.notNull(clazz, "DestinationClass");
        boolean bl = objectInputStream.readBoolean();
        if (bl) {
            return null;
        }
        ISerializationConverter<DSTTYPE> iSerializationConverter = SerializationConverterRegistry.getInstance().getConverter(clazz);
        if (iSerializationConverter == null) {
            throw new TypeConverterException(clazz, TypeConverterException.EReason.NO_CONVERTER_FOUND_SINGLE);
        }
        return GenericReflection.uncheckedCast(iSerializationConverter.readConvertedObject(objectInputStream));
    }
}

