/*
 * Decompiled with CFR 0.152.
 */
package vuegwt.shaded.com.helger.commons.state;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import vuegwt.shaded.com.helger.commons.annotation.Nonempty;
import vuegwt.shaded.com.helger.commons.id.IHasID;
import vuegwt.shaded.com.helger.commons.lang.EnumHelper;
import vuegwt.shaded.com.helger.commons.state.ITriState;

public enum ETriState implements IHasID<String>,
ITriState
{
    TRUE("true", Boolean.TRUE),
    FALSE("false", Boolean.FALSE),
    UNDEFINED("undefined", null);

    private final String m_sID;
    private final Boolean m_aBoolean;

    private ETriState(String string2, Boolean bl) {
        this.m_sID = string2;
        this.m_aBoolean = bl;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getID() {
        return this.m_sID;
    }

    @Override
    public boolean isTrue() {
        return this == TRUE;
    }

    @Override
    public boolean isFalse() {
        return this == FALSE;
    }

    @Override
    public boolean isDefined() {
        return this != UNDEFINED;
    }

    @Override
    public boolean getAsBooleanValue() {
        if (this == UNDEFINED) {
            throw new IllegalStateException("The TriState is undefined!");
        }
        return this.m_aBoolean;
    }

    @Override
    public boolean getAsBooleanValue(boolean bl) {
        return this == UNDEFINED ? bl : this.m_aBoolean;
    }

    @Override
    @Nullable
    public Boolean getAsBooleanObj() {
        return this.m_aBoolean;
    }

    @Override
    @Nullable
    public Boolean getAsBooleanObj(@Nullable Boolean bl) {
        return this == UNDEFINED ? bl : this.m_aBoolean;
    }

    @Nonnull
    public static ETriState valueOf(boolean bl) {
        return bl ? TRUE : FALSE;
    }

    @Nonnull
    public static ETriState valueOf(@Nullable Boolean bl) {
        return bl == null ? UNDEFINED : ETriState.valueOf((boolean)bl);
    }

    @Nonnull
    public static ETriState valueOf(@Nonnull ITriState iTriState) {
        return ETriState.valueOf(iTriState.getAsBooleanObj(null));
    }

    @Nullable
    public static ETriState getFromIDOrNull(@Nullable String string) {
        return EnumHelper.getFromIDOrNull(ETriState.class, string);
    }

    @Nonnull
    public static ETriState getFromIDOrUndefined(@Nullable String string) {
        return ETriState.getFromIDOrDefault(string, UNDEFINED);
    }

    @Nullable
    public static ETriState getFromIDOrDefault(@Nullable String string, @Nullable ETriState eTriState) {
        return EnumHelper.getFromIDOrDefault(ETriState.class, string, eTriState);
    }
}

