/*
 * Decompiled with CFR 0.152.
 */
package vuegwt.shaded.com.helger.commons.state;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import vuegwt.shaded.com.helger.commons.ValueEnforcer;
import vuegwt.shaded.com.helger.commons.equals.EqualsHelper;
import vuegwt.shaded.com.helger.commons.hashcode.HashCodeGenerator;
import vuegwt.shaded.com.helger.commons.state.ESuccess;
import vuegwt.shaded.com.helger.commons.state.ISuccessIndicator;
import vuegwt.shaded.com.helger.commons.string.ToStringGenerator;
import vuegwt.shaded.com.helger.commons.wrapper.IWrapper;

@Immutable
public class SuccessWithValue<DATATYPE>
implements ISuccessIndicator,
IWrapper<DATATYPE> {
    private final ESuccess m_eSuccess;
    private final DATATYPE m_aObj;

    public SuccessWithValue(@Nonnull ISuccessIndicator iSuccessIndicator) {
        this(iSuccessIndicator, null);
    }

    public SuccessWithValue(@Nonnull ISuccessIndicator iSuccessIndicator, @Nullable DATATYPE DATATYPE) {
        ValueEnforcer.notNull(iSuccessIndicator, "SuccessIndicator");
        this.m_eSuccess = ESuccess.valueOf(iSuccessIndicator);
        this.m_aObj = DATATYPE;
    }

    @Override
    public boolean isSuccess() {
        return this.m_eSuccess.isSuccess();
    }

    @Override
    @Nullable
    public DATATYPE get() {
        return this.m_aObj;
    }

    @Nullable
    public DATATYPE getIfSuccess(@Nullable DATATYPE DATATYPE) {
        return this.m_eSuccess.isSuccess() ? this.m_aObj : DATATYPE;
    }

    @Nullable
    public DATATYPE getIfSuccessOrNull() {
        return this.getIfSuccess(null);
    }

    @Nullable
    public DATATYPE getIfFailure(@Nullable DATATYPE DATATYPE) {
        return this.m_eSuccess.isFailure() ? this.m_aObj : DATATYPE;
    }

    @Nullable
    public DATATYPE getIfFailureOrNull() {
        return this.getIfFailure(null);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        SuccessWithValue successWithValue = (SuccessWithValue)object;
        return this.m_eSuccess.equals(successWithValue.m_eSuccess) && EqualsHelper.equals(this.m_aObj, successWithValue.m_aObj);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append((Enum)this.m_eSuccess)).append(this.m_aObj).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("success", this.m_eSuccess).append("obj", this.m_aObj).getToString();
    }

    @Nonnull
    public static <DATATYPE> SuccessWithValue<DATATYPE> create(@Nonnull ISuccessIndicator iSuccessIndicator, @Nullable DATATYPE DATATYPE) {
        return new SuccessWithValue<DATATYPE>(iSuccessIndicator, DATATYPE);
    }

    @Nonnull
    public static <DATATYPE> SuccessWithValue<DATATYPE> createSuccess(@Nullable DATATYPE DATATYPE) {
        return new SuccessWithValue<DATATYPE>(ESuccess.SUCCESS, DATATYPE);
    }

    @Nonnull
    public static <DATATYPE> SuccessWithValue<DATATYPE> createFailure(@Nullable DATATYPE DATATYPE) {
        return new SuccessWithValue<DATATYPE>(ESuccess.FAILURE, DATATYPE);
    }
}

