/*
 * Decompiled with CFR 0.152.
 */
package vuegwt.shaded.com.helger.commons.statistics;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.CheckForSigned;
import javax.annotation.Nonnegative;
import javax.annotation.concurrent.ThreadSafe;
import vuegwt.shaded.com.helger.commons.statistics.IMutableStatisticsHandlerCounter;

@ThreadSafe
public class StatisticsHandlerCounter
implements IMutableStatisticsHandlerCounter {
    private final AtomicInteger m_aInvocationCount = new AtomicInteger();
    private final AtomicLong m_aCount = new AtomicLong();

    @Override
    @Nonnegative
    public int getInvocationCount() {
        return this.m_aInvocationCount.intValue();
    }

    @Override
    @CheckForSigned
    public long getCount() {
        return this.m_aCount.longValue();
    }

    @Override
    public void increment() {
        this.m_aInvocationCount.incrementAndGet();
        this.m_aCount.incrementAndGet();
    }

    @Override
    public void increment(long l) {
        this.m_aInvocationCount.incrementAndGet();
        this.m_aCount.addAndGet(l);
    }
}

