/*
 * Decompiled with CFR 0.152.
 */
package vuegwt.shaded.com.helger.commons.statistics.util;

import java.util.Comparator;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import vuegwt.shaded.com.helger.commons.ValueEnforcer;
import vuegwt.shaded.com.helger.commons.collection.impl.ICommonsList;
import vuegwt.shaded.com.helger.commons.statistics.IStatisticsHandler;
import vuegwt.shaded.com.helger.commons.statistics.IStatisticsHandlerCache;
import vuegwt.shaded.com.helger.commons.statistics.IStatisticsHandlerCounter;
import vuegwt.shaded.com.helger.commons.statistics.IStatisticsHandlerKeyedCounter;
import vuegwt.shaded.com.helger.commons.statistics.IStatisticsHandlerKeyedSize;
import vuegwt.shaded.com.helger.commons.statistics.IStatisticsHandlerKeyedTimer;
import vuegwt.shaded.com.helger.commons.statistics.IStatisticsHandlerSize;
import vuegwt.shaded.com.helger.commons.statistics.IStatisticsHandlerTimer;
import vuegwt.shaded.com.helger.commons.statistics.StatisticsManager;
import vuegwt.shaded.com.helger.commons.statistics.util.IStatisticsVisitorCallback;

@Immutable
public final class StatisticsVisitor {
    private static final StatisticsVisitor s_aInstance = new StatisticsVisitor();

    private StatisticsVisitor() {
    }

    public static void visitStatistics(@Nonnull IStatisticsVisitorCallback iStatisticsVisitorCallback) {
        IStatisticsHandler iStatisticsHandler;
        ValueEnforcer.notNull(iStatisticsVisitorCallback, "Callback");
        ICommonsList iCommonsList = StatisticsManager.getAllCacheHandler().getSorted(Comparator.naturalOrder());
        for (String string : iCommonsList) {
            iStatisticsHandler = StatisticsManager.getCacheHandler(string);
            iStatisticsVisitorCallback.onCache(string, (IStatisticsHandlerCache)iStatisticsHandler);
        }
        iCommonsList = StatisticsManager.getAllTimerHandler().getSorted(Comparator.naturalOrder());
        for (String string : iCommonsList) {
            iStatisticsHandler = StatisticsManager.getTimerHandler(string);
            iStatisticsVisitorCallback.onTimer(string, (IStatisticsHandlerTimer)iStatisticsHandler);
        }
        iCommonsList = StatisticsManager.getAllKeyedTimerHandler().getSorted(Comparator.naturalOrder());
        for (String string : iCommonsList) {
            iStatisticsHandler = StatisticsManager.getKeyedTimerHandler(string);
            iStatisticsVisitorCallback.onKeyedTimer(string, (IStatisticsHandlerKeyedTimer)iStatisticsHandler);
        }
        iCommonsList = StatisticsManager.getAllSizeHandler().getSorted(Comparator.naturalOrder());
        for (String string : iCommonsList) {
            iStatisticsHandler = StatisticsManager.getSizeHandler(string);
            iStatisticsVisitorCallback.onSize(string, (IStatisticsHandlerSize)iStatisticsHandler);
        }
        iCommonsList = StatisticsManager.getAllKeyedSizeHandler().getSorted(Comparator.naturalOrder());
        for (String string : iCommonsList) {
            iStatisticsHandler = StatisticsManager.getKeyedSizeHandler(string);
            iStatisticsVisitorCallback.onKeyedSize(string, (IStatisticsHandlerKeyedSize)iStatisticsHandler);
        }
        iCommonsList = StatisticsManager.getAllCounterHandler().getSorted(Comparator.naturalOrder());
        for (String string : iCommonsList) {
            iStatisticsHandler = StatisticsManager.getCounterHandler(string);
            iStatisticsVisitorCallback.onCounter(string, (IStatisticsHandlerCounter)iStatisticsHandler);
        }
        iCommonsList = StatisticsManager.getAllKeyedCounterHandler().getSorted(Comparator.naturalOrder());
        for (String string : iCommonsList) {
            iStatisticsHandler = StatisticsManager.getKeyedCounterHandler(string);
            iStatisticsVisitorCallback.onKeyedCounter(string, (IStatisticsHandlerKeyedCounter)iStatisticsHandler);
        }
    }
}

