/*
 * Decompiled with CFR 0.152.
 */
package vuegwt.shaded.com.helger.commons.system;

import javax.annotation.concurrent.Immutable;
import vuegwt.shaded.com.helger.commons.string.StringParser;
import vuegwt.shaded.com.helger.commons.system.SystemProperties;
import vuegwt.shaded.org.slf4j.Logger;
import vuegwt.shaded.org.slf4j.LoggerFactory;

@Immutable
public final class JavaVersionHelper {
    public static final double JAVA_CLASS_VERSION = StringParser.parseDouble(SystemProperties.getJavaClassVersion(), Double.NaN);
    public static final int JAVA_MAJOR_VERSION;
    public static final int JAVA_MINOR_VERSION;
    public static final int JAVA_MICRO_VERSION;
    private static final Logger s_aLogger;
    private static final JavaVersionHelper s_aInstance;

    private JavaVersionHelper() {
    }

    public static boolean isAtLeast(int n, int n2) {
        if (JAVA_MAJOR_VERSION > n) {
            return true;
        }
        if (JAVA_MAJOR_VERSION == n) {
            return JAVA_MINOR_VERSION >= n2;
        }
        return false;
    }

    static {
        s_aLogger = LoggerFactory.getLogger(JavaVersionHelper.class);
        String string = SystemProperties.getJavaVersion();
        if (string.startsWith("1.")) {
            JAVA_MAJOR_VERSION = StringParser.parseInt((string = string.substring(2)).substring(0, string.indexOf(46)), -1);
            if (JAVA_MAJOR_VERSION < 0) {
                throw new IllegalStateException("Failed to determine Java major version from '" + string + "'");
            }
            JAVA_MINOR_VERSION = StringParser.parseInt(string.substring(string.indexOf(95) + 1), -1);
            if (JAVA_MINOR_VERSION < 0) {
                throw new IllegalStateException("Failed to determine Java minor version from '" + string + "'");
            }
            JAVA_MICRO_VERSION = -1;
        } else {
            int n = string.indexOf(46);
            JAVA_MAJOR_VERSION = StringParser.parseInt(string.substring(0, n), -1);
            if (JAVA_MAJOR_VERSION < 0) {
                throw new IllegalStateException("Failed to determine Java major version from '" + string + "'");
            }
            int n2 = string.indexOf(46, n + 1);
            JAVA_MINOR_VERSION = StringParser.parseInt(string.substring(n + 1, n2), -1);
            if (JAVA_MINOR_VERSION < 0) {
                throw new IllegalStateException("Failed to determine Java minor version from '" + string + "'");
            }
            JAVA_MICRO_VERSION = StringParser.parseInt(string.substring(n2 + 1), -1);
            if (JAVA_MICRO_VERSION < 0) {
                throw new IllegalStateException("Failed to determine Java micro version from '" + string + "'");
            }
        }
        if (s_aLogger.isDebugEnabled()) {
            s_aLogger.debug("Java version '" + SystemProperties.getJavaVersion() + "' split into MAJOR=" + JAVA_MAJOR_VERSION + " and MINOR=" + JAVA_MINOR_VERSION);
        }
        s_aInstance = new JavaVersionHelper();
    }
}

