/*
 * Decompiled with CFR 0.152.
 */
package vuegwt.shaded.com.helger.commons.system;

import java.nio.charset.Charset;
import java.util.Locale;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import vuegwt.shaded.com.helger.commons.system.EJVMVendor;
import vuegwt.shaded.com.helger.commons.system.EJavaVersion;
import vuegwt.shaded.com.helger.commons.system.EOperatingSystem;
import vuegwt.shaded.com.helger.commons.system.EProcessorArchitecture;

@Immutable
public final class SystemHelper {
    private static final int s_nNumberOfProcessors = Runtime.getRuntime().availableProcessors();
    private static final SystemHelper s_aInstance = new SystemHelper();

    private SystemHelper() {
    }

    @Nonnegative
    public static int getNumberOfProcessors() {
        return s_nNumberOfProcessors;
    }

    @Nonnull
    public static EProcessorArchitecture getProcessorArchitecture() {
        return EProcessorArchitecture.getCurrentArchitecture();
    }

    @Nonnull
    public static EOperatingSystem getOperatingSystem() {
        return EOperatingSystem.getCurrentOS();
    }

    @Nonnull
    public static String getOperatingSystemName() {
        return EOperatingSystem.getCurrentOSName() + " [" + EOperatingSystem.getCurrentOSVersion() + "]";
    }

    @Nonnull
    public static EJavaVersion getJavaVersion() {
        return EJavaVersion.getCurrentVersion();
    }

    @Nonnull
    public static EJVMVendor getJVMVendor() {
        return EJVMVendor.getCurrentVendor();
    }

    @Nonnull
    public static Locale getSystemLocale() {
        return Locale.getDefault();
    }

    @Nonnull
    public static Charset getSystemCharset() {
        return Charset.defaultCharset();
    }

    @Nonnull
    public static String getSystemCharsetName() {
        return SystemHelper.getSystemCharset().name();
    }

    @Nonnegative
    public static long getFreeMemory() {
        return Runtime.getRuntime().freeMemory();
    }

    @Nonnegative
    public static long getMaxMemory() {
        return Runtime.getRuntime().maxMemory();
    }

    @Nonnegative
    public static long getTotalMemory() {
        return Runtime.getRuntime().totalMemory();
    }
}

