/*
 * Decompiled with CFR 0.152.
 */
package vuegwt.shaded.com.helger.commons.text;

import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import vuegwt.shaded.com.helger.commons.ValueEnforcer;
import vuegwt.shaded.com.helger.commons.annotation.CodingStyleguideUnaware;
import vuegwt.shaded.com.helger.commons.annotation.ReturnsMutableCopy;
import vuegwt.shaded.com.helger.commons.annotation.ReturnsMutableObject;
import vuegwt.shaded.com.helger.commons.collection.impl.CommonsLinkedHashMap;
import vuegwt.shaded.com.helger.commons.collection.impl.ICommonsMap;
import vuegwt.shaded.com.helger.commons.collection.impl.ICommonsOrderedMap;
import vuegwt.shaded.com.helger.commons.collection.impl.ICommonsSet;
import vuegwt.shaded.com.helger.commons.debug.GlobalDebug;
import vuegwt.shaded.com.helger.commons.hashcode.HashCodeGenerator;
import vuegwt.shaded.com.helger.commons.locale.LocaleHelper;
import vuegwt.shaded.com.helger.commons.regex.RegExHelper;
import vuegwt.shaded.com.helger.commons.state.EChange;
import vuegwt.shaded.com.helger.commons.string.ToStringGenerator;
import vuegwt.shaded.com.helger.commons.text.AbstractHasText;
import vuegwt.shaded.com.helger.commons.text.IMultilingualText;
import vuegwt.shaded.org.slf4j.Logger;
import vuegwt.shaded.org.slf4j.LoggerFactory;

public abstract class AbstractReadOnlyMapBasedMultilingualText
extends AbstractHasText
implements IMultilingualText {
    private static final Logger s_aLogger = LoggerFactory.getLogger(AbstractReadOnlyMapBasedMultilingualText.class);
    private static final AtomicBoolean s_aConsistencyChecksEnabled = new AtomicBoolean(GlobalDebug.isDebugMode());
    private final ICommonsOrderedMap<Locale, String> m_aTexts;

    public AbstractReadOnlyMapBasedMultilingualText() {
        this(new CommonsLinkedHashMap<Locale, String>());
    }

    protected AbstractReadOnlyMapBasedMultilingualText(@Nonnull ICommonsOrderedMap<Locale, String> iCommonsOrderedMap) {
        this.m_aTexts = ValueEnforcer.notNull(iCommonsOrderedMap, "MapToUse");
    }

    public static void setPerformConsistencyChecks(boolean bl) {
        s_aConsistencyChecksEnabled.set(bl);
    }

    public static boolean isPerformConsistencyChecks() {
        return s_aConsistencyChecksEnabled.get();
    }

    private static void _performConsistencyChecks(@Nonnull String string) {
        if (string.contains("\\n")) {
            s_aLogger.warn("Passed string contains a masked newline - replace with an inline one:\n" + string);
        }
        if (string.contains("{0}")) {
            if (RegExHelper.stringMatchesPattern("^'[^'].*", string)) {
                throw new IllegalArgumentException("The passed string seems to start with unclosed single quotes: " + string);
            }
            if (RegExHelper.stringMatchesPattern(".*[^']'[^'].*", string)) {
                throw new IllegalArgumentException("The passed string seems to contain unclosed single quotes: " + string);
            }
        } else if (RegExHelper.stringMatchesPattern(".*''.*", string)) {
            throw new IllegalArgumentException("The passed string seems to contain 2 single quotes: " + string);
        }
    }

    protected final void internalAddText(@Nonnull Map.Entry<Locale, String> entry) {
        this.internalAddText(entry.getKey(), entry.getValue());
    }

    protected final void internalAddText(@Nonnull Locale locale, @Nullable String string) {
        ValueEnforcer.notNull(locale, "ContentLocale");
        if (this.m_aTexts.containsKey(locale)) {
            throw new IllegalArgumentException("Locale '" + locale + "' already contained: " + this.toString());
        }
        this.internalSetText(locale, string);
    }

    protected final void internalSetText(@Nonnull Locale locale, @Nullable String string) {
        if (string != null && s_aConsistencyChecksEnabled.get()) {
            AbstractReadOnlyMapBasedMultilingualText._performConsistencyChecks(string);
        }
        this.m_aTexts.put(locale, string);
    }

    @Nonnull
    protected final EChange internalRemoveText(@Nullable Locale locale) {
        return this.m_aTexts.removeObject(locale);
    }

    protected final void internalClear() {
        this.m_aTexts.clear();
    }

    @Nonnull
    @ReturnsMutableObject(value="Internal use only")
    protected final ICommonsMap<Locale, String> internalGetMap() {
        return this.m_aTexts;
    }

    @Override
    @Nullable
    protected final Locale internalGetLocaleToUseWithFallback(@Nonnull Locale locale) {
        return LocaleHelper.getLocaleToUseOrNull(locale, this.m_aTexts.keySet());
    }

    @Override
    @Nullable
    protected final String internalGetText(@Nonnull Locale locale) {
        return (String)this.m_aTexts.get(locale);
    }

    @Nonnull
    @ReturnsMutableObject(value="Internal use only")
    @CodingStyleguideUnaware
    protected final Set<Locale> internalGetAllLocales() {
        return this.m_aTexts.keySet();
    }

    @Nonnull
    @ReturnsMutableCopy
    public final ICommonsSet<Locale> getAllLocales() {
        return this.m_aTexts.copyOfKeySet();
    }

    @Nonnegative
    public final int getLocaleCount() {
        return this.m_aTexts.size();
    }

    @Override
    public final boolean containsLocale(@Nullable Locale locale) {
        return this.m_aTexts.containsKey(locale);
    }

    @Override
    public final boolean containsLocaleWithFallback(@Nullable Locale locale) {
        if (locale != null) {
            for (Locale locale2 : LocaleHelper.getCalculatedLocaleListForResolving(locale)) {
                if (!this.containsLocale(locale2)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public final ICommonsMap<Locale, String> getAllTexts() {
        return this.m_aTexts.getClone();
    }

    @Override
    @Nonnegative
    public final int size() {
        return this.m_aTexts.size();
    }

    @Override
    public final boolean isEmpty() {
        return this.m_aTexts.isEmpty();
    }

    @OverridingMethodsMustInvokeSuper
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        AbstractReadOnlyMapBasedMultilingualText abstractReadOnlyMapBasedMultilingualText = (AbstractReadOnlyMapBasedMultilingualText)object;
        return this.m_aTexts.equals(abstractReadOnlyMapBasedMultilingualText.m_aTexts);
    }

    @OverridingMethodsMustInvokeSuper
    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append(this.m_aTexts)).getHashCode();
    }

    @OverridingMethodsMustInvokeSuper
    public String toString() {
        return new ToStringGenerator(this).append("texts", this.m_aTexts).getToString();
    }
}

