/*
 * Decompiled with CFR 0.152.
 */
package vuegwt.shaded.com.helger.commons.text.resolve;

import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import vuegwt.shaded.com.helger.commons.lang.EnumHelper;
import vuegwt.shaded.com.helger.commons.statistics.IMutableStatisticsHandlerCounter;
import vuegwt.shaded.com.helger.commons.statistics.IMutableStatisticsHandlerKeyedCounter;
import vuegwt.shaded.com.helger.commons.statistics.StatisticsManager;
import vuegwt.shaded.com.helger.commons.text.IHasText;
import vuegwt.shaded.com.helger.commons.text.resolve.IEnumTextResolver;

@ThreadSafe
public abstract class AbstractEnumTextResolverWithOverrideAndFallback
implements IEnumTextResolver {
    public static final boolean DEFAULT_CHECK_FOR_OVERRIDE = true;
    public static final boolean DEFAULT_CHECK_FOR_FALLBACK = true;
    private static final IMutableStatisticsHandlerKeyedCounter s_aStatsGetText = StatisticsManager.getKeyedCounterHandler(AbstractEnumTextResolverWithOverrideAndFallback.class.getName() + "$getText");
    private static final IMutableStatisticsHandlerCounter s_aStatsOverride = StatisticsManager.getCounterHandler(AbstractEnumTextResolverWithOverrideAndFallback.class.getName() + "$OVERRIDE");
    private static final IMutableStatisticsHandlerCounter s_aStatsFallback = StatisticsManager.getCounterHandler(AbstractEnumTextResolverWithOverrideAndFallback.class.getName() + "$FALLBACK");
    private boolean m_bCheckForOverride = true;
    private boolean m_bCheckForFallback = true;

    public final boolean isCheckForOverride() {
        return this.m_bCheckForOverride;
    }

    public final void setCheckForOverride(boolean bl) {
        this.m_bCheckForOverride = bl;
    }

    public final boolean isCheckForFallback() {
        return this.m_bCheckForFallback;
    }

    public final void setCheckForFallback(boolean bl) {
        this.m_bCheckForFallback = bl;
    }

    @Nullable
    protected abstract String internalGetOverrideString(@Nonnull String var1, @Nonnull Locale var2);

    @Nullable
    protected abstract String internalGetFallbackString(@Nonnull String var1, @Nonnull Locale var2);

    @Override
    @Nullable
    public final String getText(@Nonnull Enum<?> enum_, @Nonnull IHasText iHasText, @Nonnull Locale locale) {
        String string;
        String string2 = EnumHelper.getEnumID(enum_);
        s_aStatsGetText.increment(string2);
        if (this.m_bCheckForOverride && (string = this.internalGetOverrideString(string2, locale)) != null) {
            s_aStatsOverride.increment();
            return string;
        }
        string = iHasText.getText(locale);
        if (string != null) {
            return string;
        }
        if (this.m_bCheckForFallback) {
            s_aStatsFallback.increment();
            return this.internalGetFallbackString(string2, locale);
        }
        return null;
    }
}

