/*
 * Decompiled with CFR 0.152.
 */
package vuegwt.shaded.com.helger.commons.text.resourcebundle;

import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import vuegwt.shaded.com.helger.commons.ValueEnforcer;
import vuegwt.shaded.com.helger.commons.annotation.MustImplementEqualsAndHashcode;
import vuegwt.shaded.com.helger.commons.hashcode.HashCodeGenerator;
import vuegwt.shaded.com.helger.commons.string.ToStringGenerator;
import vuegwt.shaded.com.helger.commons.text.AbstractHasText;
import vuegwt.shaded.com.helger.commons.text.IHasTextWithArgs;
import vuegwt.shaded.com.helger.commons.text.resourcebundle.ResourceBundleKey;

@Immutable
@MustImplementEqualsAndHashcode
public class ResourceBundleTextProvider
extends AbstractHasText
implements IHasTextWithArgs {
    private final ResourceBundleKey m_aResBundleKey;

    public ResourceBundleTextProvider(@Nonnull String string, @Nonnull String string2) {
        this(new ResourceBundleKey(string, string2));
    }

    public ResourceBundleTextProvider(@Nonnull ResourceBundleKey resourceBundleKey) {
        this.m_aResBundleKey = ValueEnforcer.notNull(resourceBundleKey, "ResBundleKey");
    }

    @Override
    @Nullable
    protected String internalGetText(@Nonnull Locale locale) {
        return this.m_aResBundleKey.getString(locale);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        ResourceBundleTextProvider resourceBundleTextProvider = (ResourceBundleTextProvider)object;
        return this.m_aResBundleKey.equals(resourceBundleTextProvider.m_aResBundleKey);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aResBundleKey).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("resBundleKey", this.m_aResBundleKey).getToString();
    }
}

