/*
 * Decompiled with CFR 0.152.
 */
package vuegwt.shaded.com.helger.commons.thirdparty;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import vuegwt.shaded.com.helger.commons.ValueEnforcer;
import vuegwt.shaded.com.helger.commons.annotation.ELockType;
import vuegwt.shaded.com.helger.commons.annotation.MustBeLocked;
import vuegwt.shaded.com.helger.commons.annotation.ReturnsMutableCopy;
import vuegwt.shaded.com.helger.commons.collection.impl.CommonsLinkedHashSet;
import vuegwt.shaded.com.helger.commons.collection.impl.ICommonsOrderedSet;
import vuegwt.shaded.com.helger.commons.concurrent.SimpleReadWriteLock;
import vuegwt.shaded.com.helger.commons.lang.ServiceLoaderHelper;
import vuegwt.shaded.com.helger.commons.state.EChange;
import vuegwt.shaded.com.helger.commons.thirdparty.IThirdPartyModule;
import vuegwt.shaded.com.helger.commons.thirdparty.IThirdPartyModuleProviderSPI;
import vuegwt.shaded.org.slf4j.Logger;
import vuegwt.shaded.org.slf4j.LoggerFactory;

@ThreadSafe
public final class ThirdPartyModuleRegistry {
    private static final Logger s_aLogger = LoggerFactory.getLogger(ThirdPartyModuleRegistry.class);
    private static boolean s_bDefaultInstantiated = false;
    private final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="m_aRWLock")
    private final ICommonsOrderedSet<IThirdPartyModule> m_aModules = new CommonsLinkedHashSet<IThirdPartyModule>();

    private ThirdPartyModuleRegistry() {
        this.reinitialize();
    }

    public static boolean isInstantiated() {
        return s_bDefaultInstantiated;
    }

    @Nonnull
    public static ThirdPartyModuleRegistry getInstance() {
        ThirdPartyModuleRegistry thirdPartyModuleRegistry = SingletonHolder.s_aInstance;
        s_bDefaultInstantiated = true;
        return thirdPartyModuleRegistry;
    }

    @Nonnull
    @MustBeLocked(value=ELockType.WRITE)
    private EChange _registerThirdPartyModule(@Nonnull IThirdPartyModule iThirdPartyModule) {
        ValueEnforcer.notNull(iThirdPartyModule, "Module");
        return this.m_aModules.addObject(iThirdPartyModule);
    }

    @Nonnull
    public EChange registerThirdPartyModule(@Nonnull IThirdPartyModule iThirdPartyModule) {
        return this.m_aRWLock.writeLocked(() -> this._registerThirdPartyModule(iThirdPartyModule));
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedSet<IThirdPartyModule> getAllRegisteredThirdPartyModules() {
        return this.m_aRWLock.readLocked(() -> this.m_aModules.getClone());
    }

    @Nonnegative
    public int getRegisteredThirdPartyModuleCount() {
        return this.m_aRWLock.readLocked(() -> this.m_aModules.size());
    }

    public void reinitialize() {
        this.m_aRWLock.writeLocked(() -> {
            this.m_aModules.clear();
            for (IThirdPartyModuleProviderSPI iThirdPartyModuleProviderSPI : ServiceLoaderHelper.getAllSPIImplementations(IThirdPartyModuleProviderSPI.class)) {
                IThirdPartyModule[] iThirdPartyModuleArray = iThirdPartyModuleProviderSPI.getAllThirdPartyModules();
                if (iThirdPartyModuleArray == null) continue;
                for (IThirdPartyModule iThirdPartyModule : iThirdPartyModuleArray) {
                    this._registerThirdPartyModule(iThirdPartyModule);
                }
            }
        });
        if (s_aLogger.isDebugEnabled()) {
            s_aLogger.debug("Reinitialized " + ThirdPartyModuleRegistry.class.getName());
        }
    }

    private static final class SingletonHolder {
        private static final ThirdPartyModuleRegistry s_aInstance = new ThirdPartyModuleRegistry();

        private SingletonHolder() {
        }
    }
}

