/*
 * Decompiled with CFR 0.152.
 */
package vuegwt.shaded.com.helger.commons.type;

import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import vuegwt.shaded.com.helger.commons.ValueEnforcer;
import vuegwt.shaded.com.helger.commons.hashcode.HashCodeGenerator;
import vuegwt.shaded.com.helger.commons.string.ToStringGenerator;
import vuegwt.shaded.com.helger.commons.type.ITypedObject;
import vuegwt.shaded.com.helger.commons.type.ObjectType;

@Immutable
public final class TypedObject<IDTYPE extends Serializable>
implements ITypedObject<IDTYPE>,
Serializable {
    private ObjectType m_aObjectType;
    private IDTYPE m_aID;

    public TypedObject(@Nonnull ITypedObject<IDTYPE> iTypedObject) {
        this(iTypedObject.getObjectType(), (Serializable)iTypedObject.getID());
    }

    public TypedObject(@Nonnull ObjectType objectType, @Nonnull IDTYPE IDTYPE) {
        this.m_aObjectType = ValueEnforcer.notNull(objectType, "ObjectType");
        this.m_aID = (Serializable)ValueEnforcer.notNull(IDTYPE, "ID");
    }

    @Override
    @Nonnull
    public ObjectType getObjectType() {
        return this.m_aObjectType;
    }

    @Override
    @Nonnull
    public IDTYPE getID() {
        return this.m_aID;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        TypedObject typedObject = (TypedObject)object;
        return this.m_aObjectType.equals(typedObject.m_aObjectType) && this.m_aID.equals(typedObject.m_aID);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aObjectType).append(this.m_aID).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("ObjectType", this.m_aObjectType).append("ID", this.m_aID).getToString();
    }

    @Nonnull
    public static <IDTYPE extends Serializable> TypedObject<IDTYPE> create(@Nonnull ITypedObject<IDTYPE> iTypedObject) {
        return new TypedObject<IDTYPE>(iTypedObject);
    }

    @Nonnull
    public static <IDTYPE extends Serializable> TypedObject<IDTYPE> create(@Nonnull ObjectType objectType, @Nonnull IDTYPE IDTYPE) {
        return new TypedObject<IDTYPE>(objectType, IDTYPE);
    }
}

