/*
 * Decompiled with CFR 0.152.
 */
package vuegwt.shaded.com.helger.commons.typeconvert.rule;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import vuegwt.shaded.com.helger.commons.ValueEnforcer;
import vuegwt.shaded.com.helger.commons.functional.IFunction;
import vuegwt.shaded.com.helger.commons.string.ToStringGenerator;
import vuegwt.shaded.com.helger.commons.typeconvert.ITypeConverterRule;
import vuegwt.shaded.com.helger.commons.typeconvert.rule.AbstractTypeConverterRule;

public class TypeConverterRuleAnySourceFixedDestination<DST>
extends AbstractTypeConverterRule<Object, DST> {
    private final Class<DST> m_aDstClass;
    private final IFunction<? super Object, ? extends DST> m_aConverter;

    public TypeConverterRuleAnySourceFixedDestination(@Nonnull Class<DST> clazz, @Nonnull IFunction<? super Object, ? extends DST> iFunction) {
        super(ITypeConverterRule.ESubType.ANY_SRC_FIXED_DST);
        this.m_aDstClass = ValueEnforcer.notNull(clazz, "DestClass");
        this.m_aConverter = ValueEnforcer.notNull(iFunction, "Converter");
    }

    @Override
    public final boolean canConvert(@Nonnull Class<?> clazz, @Nonnull Class<?> clazz2) {
        return this.m_aDstClass.equals(clazz2);
    }

    @Nonnull
    public final Class<?> getDestinationClass() {
        return this.m_aDstClass;
    }

    @Override
    @Nullable
    public DST apply(@Nonnull Object object) {
        return (DST)this.m_aConverter.apply(object);
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("DstClass", this.m_aDstClass).append("Converter", this.m_aConverter).getToString();
    }
}

