/*
 * Decompiled with CFR 0.152.
 */
package vuegwt.shaded.com.helger.commons.typeconvert.rule;

import javax.annotation.Nonnull;
import vuegwt.shaded.com.helger.commons.ValueEnforcer;
import vuegwt.shaded.com.helger.commons.functional.IFunction;
import vuegwt.shaded.com.helger.commons.string.ToStringGenerator;
import vuegwt.shaded.com.helger.commons.typeconvert.ITypeConverterRule;
import vuegwt.shaded.com.helger.commons.typeconvert.TypeConverter;
import vuegwt.shaded.com.helger.commons.typeconvert.rule.AbstractTypeConverterRule;

public class TypeConverterRuleFixedSourceAnyDestination<SRC>
extends AbstractTypeConverterRule<SRC, Object> {
    private final Class<SRC> m_aSrcClass;
    private final IFunction<? super SRC, ? extends Object> m_aInBetweenConverter;
    private transient Class<?> m_aEffectiveDstClass;

    public TypeConverterRuleFixedSourceAnyDestination(@Nonnull Class<SRC> clazz, @Nonnull IFunction<? super SRC, ? extends Object> iFunction) {
        super(ITypeConverterRule.ESubType.FIXED_SRC_ANY_DST);
        this.m_aSrcClass = ValueEnforcer.notNull(clazz, "SrcClass");
        this.m_aInBetweenConverter = ValueEnforcer.notNull(iFunction, "InBetweenConverter");
    }

    @Override
    public final boolean canConvert(@Nonnull Class<?> clazz, @Nonnull Class<?> clazz2) {
        if (!this.m_aSrcClass.equals(clazz)) {
            return false;
        }
        this.m_aEffectiveDstClass = clazz2;
        return true;
    }

    @Nonnull
    protected Object getInBetweenValue(@Nonnull SRC SRC) {
        return this.m_aInBetweenConverter.apply(SRC);
    }

    @Override
    public final Object apply(@Nonnull SRC SRC) {
        Object object = this.getInBetweenValue(SRC);
        return TypeConverter.convert(object, this.m_aEffectiveDstClass);
    }

    @Nonnull
    public final Class<?> getSourceClass() {
        return this.m_aSrcClass;
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("SrcClass", this.m_aSrcClass).append("InBetweenConverter", this.m_aInBetweenConverter).getToString();
    }
}

