/*
 * Decompiled with CFR 0.152.
 */
package vuegwt.shaded.com.helger.commons.url;

import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import vuegwt.shaded.com.helger.commons.ValueEnforcer;
import vuegwt.shaded.com.helger.commons.annotation.ReturnsMutableObject;
import vuegwt.shaded.com.helger.commons.equals.EqualsHelper;
import vuegwt.shaded.com.helger.commons.string.StringHelper;
import vuegwt.shaded.com.helger.commons.url.IURLProtocol;
import vuegwt.shaded.com.helger.commons.url.URLHelper;
import vuegwt.shaded.com.helger.commons.url.URLParameterList;
import vuegwt.shaded.com.helger.commons.url.URLProtocolRegistry;

public interface ISimpleURL
extends Serializable {
    @Nullable
    default public IURLProtocol getProtocol() {
        return URLProtocolRegistry.getInstance().getProtocol(this.getPath());
    }

    default public boolean hasKnownProtocol() {
        return URLProtocolRegistry.getInstance().hasKnownProtocol(this.getPath());
    }

    @Nonnull
    public String getPath();

    @Nullable
    @ReturnsMutableObject
    public URLParameterList params();

    @Nullable
    public String getAnchor();

    default public boolean hasAnchor() {
        return StringHelper.hasText(this.getAnchor());
    }

    default public boolean hasAnchor(@Nullable String string) {
        return EqualsHelper.equals(string, this.getAnchor());
    }

    @Nonnull
    default public String getAsStringWithoutEncodedParameters() {
        return URLHelper.getURLString(this, null);
    }

    @Nonnull
    default public String getAsStringWithEncodedParameters() {
        return URLHelper.getURLString(this, URLHelper.CHARSET_URL_OBJ);
    }

    @Nonnull
    default public String getAsStringWithEncodedParameters(@Nonnull Charset charset) {
        ValueEnforcer.notNull(charset, "ParameterCharset");
        return URLHelper.getURLString(this, charset);
    }

    @Nullable
    default public URL getAsURL() {
        return URLHelper.getAsURL(this.getAsStringWithEncodedParameters());
    }

    @Nullable
    default public URI getAsURI() {
        return URLHelper.getAsURI(this.getAsStringWithEncodedParameters());
    }
}

