/*
 * Decompiled with CFR 0.152.
 */
package vuegwt.shaded.com.helger.commons.url;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import vuegwt.shaded.com.helger.commons.ValueEnforcer;
import vuegwt.shaded.com.helger.commons.annotation.ReturnsMutableObject;
import vuegwt.shaded.com.helger.commons.equals.EqualsHelper;
import vuegwt.shaded.com.helger.commons.hashcode.HashCodeGenerator;
import vuegwt.shaded.com.helger.commons.lang.IHasSize;
import vuegwt.shaded.com.helger.commons.string.ToStringGenerator;
import vuegwt.shaded.com.helger.commons.url.ISimpleURL;
import vuegwt.shaded.com.helger.commons.url.URLParameterList;

@Immutable
public class URLData
implements ISimpleURL {
    public static final URLData EMPTY_URL_DATA = new URLData("");
    private final String m_sPath;
    private final URLParameterList m_aParams;
    private final String m_sAnchor;

    public URLData(@Nonnull String string) {
        this(string, null, null);
    }

    public URLData(@Nonnull String string, @Nullable URLParameterList uRLParameterList) {
        this(string, uRLParameterList, null);
    }

    public URLData(@Nonnull String string, @Nullable URLParameterList uRLParameterList, @Nullable String string2) {
        this.m_sPath = ValueEnforcer.notNull(string, "Path");
        this.m_aParams = uRLParameterList != null ? uRLParameterList : new URLParameterList();
        this.m_sAnchor = string2;
    }

    @Override
    @Nonnull
    public final String getPath() {
        return this.m_sPath;
    }

    @Override
    @Nonnull
    @ReturnsMutableObject
    public final URLParameterList params() {
        return this.m_aParams;
    }

    @Override
    @Nullable
    public final String getAnchor() {
        return this.m_sAnchor;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        URLData uRLData = (URLData)object;
        return this.m_sPath.equals(uRLData.m_sPath) && this.m_aParams.equals(uRLData.m_aParams) && EqualsHelper.equals(this.m_sAnchor, uRLData.m_sAnchor);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append(this.m_sPath).append((Iterable)this.m_aParams)).append(this.m_sAnchor).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("Path", this.m_sPath).appendIf("Params", this.m_aParams, IHasSize::isNotEmpty).appendIfNotNull("Anchor", this.m_sAnchor).getToString();
    }
}

