/*
 * Decompiled with CFR 0.152.
 */
package vuegwt.shaded.com.helger.css;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import vuegwt.shaded.com.helger.commons.string.StringHelper;

@Immutable
public final class CSSFilenameHelper {
    private static final CSSFilenameHelper s_aInstance = new CSSFilenameHelper();

    private CSSFilenameHelper() {
    }

    public static boolean isCSSFilename(@Nullable String string) {
        return StringHelper.endsWith(string, ".css");
    }

    public static boolean isMinifiedCSSFilename(@Nullable String string) {
        return StringHelper.endsWith(string, ".min.css");
    }

    public static boolean isRegularCSSFilename(@Nullable String string) {
        return CSSFilenameHelper.isCSSFilename(string) && !CSSFilenameHelper.isMinifiedCSSFilename(string);
    }

    @Nonnull
    public static String getMinifiedCSSFilename(@Nonnull String string) {
        if (!CSSFilenameHelper.isCSSFilename(string)) {
            throw new IllegalArgumentException("Passed file name '" + string + "' is not a CSS file name!");
        }
        if (CSSFilenameHelper.isMinifiedCSSFilename(string)) {
            return string;
        }
        return StringHelper.trimEnd(string, ".css") + ".min.css";
    }
}

