/*
 * Decompiled with CFR 0.152.
 */
package vuegwt.shaded.com.helger.css;

import java.io.Serializable;
import javax.annotation.CheckForSigned;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import vuegwt.shaded.com.helger.commons.annotation.Nonempty;
import vuegwt.shaded.com.helger.commons.equals.EqualsHelper;
import vuegwt.shaded.com.helger.commons.hashcode.HashCodeGenerator;
import vuegwt.shaded.com.helger.commons.string.StringHelper;
import vuegwt.shaded.com.helger.commons.string.ToStringGenerator;
import vuegwt.shaded.com.helger.css.CSSSourceArea;

@Immutable
public class CSSSourceLocation
implements Serializable {
    private final CSSSourceArea m_aFirstTokenArea;
    private final CSSSourceArea m_aLastTokenArea;

    public CSSSourceLocation(@Nullable CSSSourceArea cSSSourceArea, @Nullable CSSSourceArea cSSSourceArea2) {
        if (cSSSourceArea == null && cSSSourceArea2 == null) {
            throw new IllegalArgumentException("At least one of the areas must be set!");
        }
        this.m_aFirstTokenArea = cSSSourceArea;
        this.m_aLastTokenArea = cSSSourceArea2;
    }

    @Nullable
    public CSSSourceArea getFirstTokenArea() {
        return this.m_aFirstTokenArea;
    }

    public boolean hasFirstTokenArea() {
        return this.m_aFirstTokenArea != null;
    }

    @CheckForSigned
    public int getFirstTokenBeginLineNumber() {
        return this.m_aFirstTokenArea == null ? -1 : this.m_aFirstTokenArea.getTokenBeginLineNumber();
    }

    @CheckForSigned
    public int getFirstTokenBeginColumnNumber() {
        return this.m_aFirstTokenArea == null ? -1 : this.m_aFirstTokenArea.getTokenBeginColumnNumber();
    }

    @CheckForSigned
    public int getFirstTokenEndLineNumber() {
        return this.m_aFirstTokenArea == null ? -1 : this.m_aFirstTokenArea.getTokenEndLineNumber();
    }

    @CheckForSigned
    public int getFirstTokenEndColumnNumber() {
        return this.m_aFirstTokenArea == null ? -1 : this.m_aFirstTokenArea.getTokenEndColumnNumber();
    }

    @Nullable
    public CSSSourceArea getLastTokenArea() {
        return this.m_aLastTokenArea;
    }

    public boolean hasLastTokenArea() {
        return this.m_aLastTokenArea != null;
    }

    @CheckForSigned
    public int getLastTokenBeginLineNumber() {
        return this.m_aLastTokenArea == null ? -1 : this.m_aLastTokenArea.getTokenBeginLineNumber();
    }

    @CheckForSigned
    public int getLastTokenBeginColumnNumber() {
        return this.m_aLastTokenArea == null ? -1 : this.m_aLastTokenArea.getTokenBeginColumnNumber();
    }

    @CheckForSigned
    public int getLastTokenEndLineNumber() {
        return this.m_aLastTokenArea == null ? -1 : this.m_aLastTokenArea.getTokenEndLineNumber();
    }

    @CheckForSigned
    public int getLastTokenEndColumnNumber() {
        return this.m_aLastTokenArea == null ? -1 : this.m_aLastTokenArea.getTokenEndColumnNumber();
    }

    @Nullable
    public String getFirstTokenLocationAsString() {
        return this.m_aFirstTokenArea == null ? null : this.m_aFirstTokenArea.getTokenLocationAsString();
    }

    @Nullable
    public String getLastTokenLocationAsString() {
        return this.m_aLastTokenArea == null ? null : this.m_aLastTokenArea.getTokenLocationAsString();
    }

    @Nonnull
    @Nonempty
    public String getLocationAsString() {
        String string = this.getFirstTokenLocationAsString();
        String string2 = this.getLastTokenLocationAsString();
        return StringHelper.getNotNull(string, "") + "-" + StringHelper.getNotNull(string2, "");
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSSourceLocation cSSSourceLocation = (CSSSourceLocation)object;
        return EqualsHelper.equals(this.m_aFirstTokenArea, cSSSourceLocation.m_aFirstTokenArea) && EqualsHelper.equals(this.m_aLastTokenArea, cSSSourceLocation.m_aLastTokenArea);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aFirstTokenArea).append(this.m_aLastTokenArea).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("firstTokenArea", this.m_aFirstTokenArea).append("lastTokenArea", this.m_aLastTokenArea).getToString();
    }
}

