/*
 * Decompiled with CFR 0.152.
 */
package vuegwt.shaded.com.helger.css.decl;

import java.io.Serializable;
import java.util.function.Predicate;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import vuegwt.shaded.com.helger.commons.ValueEnforcer;
import vuegwt.shaded.com.helger.commons.annotation.ReturnsMutableCopy;
import vuegwt.shaded.com.helger.commons.collection.impl.CommonsArrayList;
import vuegwt.shaded.com.helger.commons.collection.impl.ICommonsList;
import vuegwt.shaded.com.helger.commons.state.EChange;
import vuegwt.shaded.com.helger.css.decl.CSSFontFaceRule;
import vuegwt.shaded.com.helger.css.decl.CSSKeyframesRule;
import vuegwt.shaded.com.helger.css.decl.CSSMediaRule;
import vuegwt.shaded.com.helger.css.decl.CSSPageRule;
import vuegwt.shaded.com.helger.css.decl.CSSStyleRule;
import vuegwt.shaded.com.helger.css.decl.CSSSupportsRule;
import vuegwt.shaded.com.helger.css.decl.CSSUnknownRule;
import vuegwt.shaded.com.helger.css.decl.CSSViewportRule;
import vuegwt.shaded.com.helger.css.decl.ICSSTopLevelRule;

@NotThreadSafe
public abstract class AbstractHasTopLevelRules
implements Serializable {
    protected final ICommonsList<ICSSTopLevelRule> m_aRules = new CommonsArrayList<ICSSTopLevelRule>();

    public boolean hasRules() {
        return this.m_aRules.isNotEmpty();
    }

    @Nonnegative
    public int getRuleCount() {
        return this.m_aRules.size();
    }

    @Nullable
    @Deprecated
    public ICSSTopLevelRule getRule(@Nonnegative int n) {
        return this.getRuleAtIndex(n);
    }

    @Nullable
    public ICSSTopLevelRule getRuleAtIndex(@Nonnegative int n) {
        return (ICSSTopLevelRule)this.m_aRules.getAtIndex(n);
    }

    @Nonnull
    public AbstractHasTopLevelRules addRule(@Nonnull ICSSTopLevelRule iCSSTopLevelRule) {
        ValueEnforcer.notNull(iCSSTopLevelRule, "Rule");
        this.m_aRules.add(iCSSTopLevelRule);
        return this;
    }

    @Nonnull
    public AbstractHasTopLevelRules addRule(@Nonnegative int n, @Nonnull ICSSTopLevelRule iCSSTopLevelRule) {
        ValueEnforcer.isGE0(n, "Index");
        ValueEnforcer.notNull(iCSSTopLevelRule, "Rule");
        if (n >= this.getRuleCount()) {
            this.m_aRules.add(iCSSTopLevelRule);
        } else {
            this.m_aRules.add(n, iCSSTopLevelRule);
        }
        return this;
    }

    @Nonnull
    public EChange removeRule(@Nullable ICSSTopLevelRule iCSSTopLevelRule) {
        return this.m_aRules.removeObject(iCSSTopLevelRule);
    }

    @Nonnull
    public EChange removeRule(@Nonnegative int n) {
        return this.m_aRules.removeAtIndex(n);
    }

    @Nonnull
    public EChange removeRules(@Nonnull Predicate<? super ICSSTopLevelRule> predicate) {
        return EChange.valueOf(this.m_aRules.removeIf(predicate));
    }

    @Nonnull
    public EChange removeAllRules() {
        return this.m_aRules.removeAll();
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<ICSSTopLevelRule> getAllRules() {
        return (ICommonsList)this.m_aRules.getClone();
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<ICSSTopLevelRule> getAllRules(@Nonnull Predicate<? super ICSSTopLevelRule> predicate) {
        return this.m_aRules.getAll(predicate);
    }

    public boolean hasStyleRules() {
        return this.m_aRules.containsAny(iCSSTopLevelRule -> iCSSTopLevelRule instanceof CSSStyleRule);
    }

    @Nonnegative
    public int getStyleRuleCount() {
        return this.m_aRules.getCount(iCSSTopLevelRule -> iCSSTopLevelRule instanceof CSSStyleRule);
    }

    @Nullable
    public CSSStyleRule getStyleRuleAtIndex(@Nonnegative int n) {
        return this.m_aRules.getAtIndexMapped(iCSSTopLevelRule -> iCSSTopLevelRule instanceof CSSStyleRule, n, iCSSTopLevelRule -> (CSSStyleRule)iCSSTopLevelRule);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<CSSStyleRule> getAllStyleRules() {
        return this.m_aRules.getAllMapped(iCSSTopLevelRule -> iCSSTopLevelRule instanceof CSSStyleRule, iCSSTopLevelRule -> (CSSStyleRule)iCSSTopLevelRule);
    }

    public boolean hasPageRules() {
        return this.m_aRules.containsAny(iCSSTopLevelRule -> iCSSTopLevelRule instanceof CSSPageRule);
    }

    @Nonnegative
    public int getPageRuleCount() {
        return this.m_aRules.getCount(iCSSTopLevelRule -> iCSSTopLevelRule instanceof CSSPageRule);
    }

    @Nullable
    public CSSPageRule getPageRuleAtIndex(@Nonnegative int n) {
        return this.m_aRules.getAtIndexMapped(iCSSTopLevelRule -> iCSSTopLevelRule instanceof CSSPageRule, n, iCSSTopLevelRule -> (CSSPageRule)iCSSTopLevelRule);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<CSSPageRule> getAllPageRules() {
        return this.m_aRules.getAllMapped(iCSSTopLevelRule -> iCSSTopLevelRule instanceof CSSPageRule, iCSSTopLevelRule -> (CSSPageRule)iCSSTopLevelRule);
    }

    public boolean hasMediaRules() {
        return this.m_aRules.containsAny(iCSSTopLevelRule -> iCSSTopLevelRule instanceof CSSMediaRule);
    }

    @Nonnegative
    public int getMediaRuleCount() {
        return this.m_aRules.getCount(iCSSTopLevelRule -> iCSSTopLevelRule instanceof CSSMediaRule);
    }

    @Nullable
    public CSSMediaRule getMediaRuleAtIndex(@Nonnegative int n) {
        return this.m_aRules.getAtIndexMapped(iCSSTopLevelRule -> iCSSTopLevelRule instanceof CSSMediaRule, n, iCSSTopLevelRule -> (CSSMediaRule)iCSSTopLevelRule);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<CSSMediaRule> getAllMediaRules() {
        return this.m_aRules.getAllMapped(iCSSTopLevelRule -> iCSSTopLevelRule instanceof CSSMediaRule, iCSSTopLevelRule -> (CSSMediaRule)iCSSTopLevelRule);
    }

    public boolean hasFontFaceRules() {
        return this.m_aRules.containsAny(iCSSTopLevelRule -> iCSSTopLevelRule instanceof CSSFontFaceRule);
    }

    @Nonnegative
    public int getFontFaceRuleCount() {
        return this.m_aRules.getCount(iCSSTopLevelRule -> iCSSTopLevelRule instanceof CSSFontFaceRule);
    }

    @Nullable
    public CSSFontFaceRule getFontFaceRuleAtIndex(@Nonnegative int n) {
        return this.m_aRules.getAtIndexMapped(iCSSTopLevelRule -> iCSSTopLevelRule instanceof CSSFontFaceRule, n, iCSSTopLevelRule -> (CSSFontFaceRule)iCSSTopLevelRule);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<CSSFontFaceRule> getAllFontFaceRules() {
        return this.m_aRules.getAllMapped(iCSSTopLevelRule -> iCSSTopLevelRule instanceof CSSFontFaceRule, iCSSTopLevelRule -> (CSSFontFaceRule)iCSSTopLevelRule);
    }

    public boolean hasKeyframesRules() {
        return this.m_aRules.containsAny(iCSSTopLevelRule -> iCSSTopLevelRule instanceof CSSKeyframesRule);
    }

    @Nonnegative
    public int getKeyframesRuleCount() {
        return this.m_aRules.getCount(iCSSTopLevelRule -> iCSSTopLevelRule instanceof CSSKeyframesRule);
    }

    @Nullable
    public CSSKeyframesRule getKeyframesRuleAtIndex(@Nonnegative int n) {
        return this.m_aRules.getAtIndexMapped(iCSSTopLevelRule -> iCSSTopLevelRule instanceof CSSKeyframesRule, n, iCSSTopLevelRule -> (CSSKeyframesRule)iCSSTopLevelRule);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<CSSKeyframesRule> getAllKeyframesRules() {
        return this.m_aRules.getAllMapped(iCSSTopLevelRule -> iCSSTopLevelRule instanceof CSSKeyframesRule, iCSSTopLevelRule -> (CSSKeyframesRule)iCSSTopLevelRule);
    }

    public boolean hasViewportRules() {
        return this.m_aRules.containsAny(iCSSTopLevelRule -> iCSSTopLevelRule instanceof CSSViewportRule);
    }

    @Nonnegative
    public int getViewportRuleCount() {
        return this.m_aRules.getCount(iCSSTopLevelRule -> iCSSTopLevelRule instanceof CSSViewportRule);
    }

    @Nullable
    public CSSViewportRule getViewportRuleAtIndex(@Nonnegative int n) {
        return this.m_aRules.getAtIndexMapped(iCSSTopLevelRule -> iCSSTopLevelRule instanceof CSSViewportRule, n, iCSSTopLevelRule -> (CSSViewportRule)iCSSTopLevelRule);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<CSSViewportRule> getAllViewportRules() {
        return this.m_aRules.getAllMapped(iCSSTopLevelRule -> iCSSTopLevelRule instanceof CSSViewportRule, iCSSTopLevelRule -> (CSSViewportRule)iCSSTopLevelRule);
    }

    public boolean hasSupportsRules() {
        return this.m_aRules.containsAny(iCSSTopLevelRule -> iCSSTopLevelRule instanceof CSSSupportsRule);
    }

    @Nonnegative
    public int getSupportsRuleCount() {
        return this.m_aRules.getCount(iCSSTopLevelRule -> iCSSTopLevelRule instanceof CSSSupportsRule);
    }

    @Nullable
    public CSSSupportsRule getSupportsRuleAtIndex(@Nonnegative int n) {
        return this.m_aRules.getAtIndexMapped(iCSSTopLevelRule -> iCSSTopLevelRule instanceof CSSSupportsRule, n, iCSSTopLevelRule -> (CSSSupportsRule)iCSSTopLevelRule);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<CSSSupportsRule> getAllSupportsRules() {
        return this.m_aRules.getAllMapped(iCSSTopLevelRule -> iCSSTopLevelRule instanceof CSSSupportsRule, iCSSTopLevelRule -> (CSSSupportsRule)iCSSTopLevelRule);
    }

    public boolean hasUnknownRules() {
        return this.m_aRules.containsAny(iCSSTopLevelRule -> iCSSTopLevelRule instanceof CSSUnknownRule);
    }

    @Nonnegative
    public int getUnknownRuleCount() {
        return this.m_aRules.getCount(iCSSTopLevelRule -> iCSSTopLevelRule instanceof CSSUnknownRule);
    }

    @Nullable
    public CSSUnknownRule getUnknownRuleAtIndex(@Nonnegative int n) {
        return this.m_aRules.getAtIndexMapped(iCSSTopLevelRule -> iCSSTopLevelRule instanceof CSSUnknownRule, n, iCSSTopLevelRule -> (CSSUnknownRule)iCSSTopLevelRule);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<CSSUnknownRule> getAllUnknownRules() {
        return this.m_aRules.getAllMapped(iCSSTopLevelRule -> iCSSTopLevelRule instanceof CSSUnknownRule, iCSSTopLevelRule -> (CSSUnknownRule)iCSSTopLevelRule);
    }
}

