/*
 * Decompiled with CFR 0.152.
 */
package vuegwt.shaded.com.helger.css.decl;

import java.util.Locale;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import vuegwt.shaded.com.helger.commons.ValueEnforcer;
import vuegwt.shaded.com.helger.commons.annotation.Nonempty;
import vuegwt.shaded.com.helger.commons.annotation.ReturnsMutableObject;
import vuegwt.shaded.com.helger.commons.hashcode.HashCodeGenerator;
import vuegwt.shaded.com.helger.commons.string.ToStringGenerator;
import vuegwt.shaded.com.helger.css.CSSSourceLocation;
import vuegwt.shaded.com.helger.css.ICSSSourceLocationAware;
import vuegwt.shaded.com.helger.css.ICSSWriterSettings;
import vuegwt.shaded.com.helger.css.decl.CSSExpression;
import vuegwt.shaded.com.helger.css.decl.ICSSPageRuleMember;
import vuegwt.shaded.com.helger.css.property.ECSSProperty;

@NotThreadSafe
public class CSSDeclaration
implements ICSSSourceLocationAware,
ICSSPageRuleMember {
    public static final boolean DEFAULT_IMPORTANT = false;
    private String m_sProperty;
    private CSSExpression m_aExpression;
    private boolean m_bIsImportant;
    private CSSSourceLocation m_aSourceLocation;

    public CSSDeclaration(@Nonnull @Nonempty String string, @Nonnull CSSExpression cSSExpression) {
        this(string, cSSExpression, false);
    }

    public CSSDeclaration(@Nonnull @Nonempty String string, @Nonnull CSSExpression cSSExpression, boolean bl) {
        this.setProperty(string);
        this.setExpression(cSSExpression);
        this.setImportant(bl);
    }

    @Nonnull
    @Nonempty
    public String getProperty() {
        return this.m_sProperty;
    }

    @Nonnull
    private static String _unifyProperty(@Nonnull String string) {
        return string.toLowerCase(Locale.US);
    }

    public boolean hasProperty(@Nonnull String string) {
        ValueEnforcer.notNull(string, "Property");
        return this.m_sProperty.equals(CSSDeclaration._unifyProperty(string));
    }

    public boolean hasProperty(@Nonnull ECSSProperty eCSSProperty) {
        ValueEnforcer.notNull(eCSSProperty, "Property");
        return this.hasProperty(eCSSProperty.getName());
    }

    @Nonnull
    public CSSDeclaration setProperty(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "Property");
        this.m_sProperty = CSSDeclaration._unifyProperty(string);
        return this;
    }

    @Nonnull
    public CSSDeclaration setProperty(@Nonnull ECSSProperty eCSSProperty) {
        ValueEnforcer.notNull(eCSSProperty, "Property");
        return this.setProperty(eCSSProperty.getName());
    }

    @Nonnull
    @ReturnsMutableObject
    public CSSExpression getExpression() {
        return this.m_aExpression;
    }

    @Nonnull
    public String getExpressionAsCSSString() {
        return this.m_aExpression.getAsCSSString();
    }

    @Nonnull
    public CSSDeclaration setExpression(@Nonnull CSSExpression cSSExpression) {
        this.m_aExpression = ValueEnforcer.notNull(cSSExpression, "Expression");
        return this;
    }

    public boolean isImportant() {
        return this.m_bIsImportant;
    }

    @Nonnull
    public CSSDeclaration setImportant(boolean bl) {
        this.m_bIsImportant = bl;
        return this;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        return this.m_sProperty + ':' + this.m_aExpression.getAsCSSString(iCSSWriterSettings, n) + (this.m_bIsImportant ? " !important" : "");
    }

    @Override
    public void setSourceLocation(@Nullable CSSSourceLocation cSSSourceLocation) {
        this.m_aSourceLocation = cSSSourceLocation;
    }

    @Override
    @Nullable
    public CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSDeclaration cSSDeclaration = (CSSDeclaration)object;
        return this.m_sProperty.equals(cSSDeclaration.m_sProperty) && this.m_aExpression.equals(cSSDeclaration.m_aExpression) && this.m_bIsImportant == cSSDeclaration.m_bIsImportant;
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_sProperty).append(this.m_aExpression).append(this.m_bIsImportant).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("property", this.m_sProperty).append("expression", this.m_aExpression).append("important", this.m_bIsImportant).appendIfNotNull("sourceLocation", this.m_aSourceLocation).getToString();
    }
}

