/*
 * Decompiled with CFR 0.152.
 */
package vuegwt.shaded.com.helger.css.decl;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import vuegwt.shaded.com.helger.commons.ValueEnforcer;
import vuegwt.shaded.com.helger.commons.annotation.Nonempty;
import vuegwt.shaded.com.helger.commons.annotation.ReturnsMutableCopy;
import vuegwt.shaded.com.helger.commons.collection.impl.CommonsArrayList;
import vuegwt.shaded.com.helger.commons.collection.impl.ICommonsList;
import vuegwt.shaded.com.helger.commons.hashcode.HashCodeGenerator;
import vuegwt.shaded.com.helger.commons.state.EChange;
import vuegwt.shaded.com.helger.commons.string.StringHelper;
import vuegwt.shaded.com.helger.commons.string.ToStringGenerator;
import vuegwt.shaded.com.helger.css.CSSSourceLocation;
import vuegwt.shaded.com.helger.css.ICSSSourceLocationAware;
import vuegwt.shaded.com.helger.css.ICSSWriteable;
import vuegwt.shaded.com.helger.css.ICSSWriterSettings;
import vuegwt.shaded.com.helger.css.decl.CSSExpressionMemberTermSimple;
import vuegwt.shaded.com.helger.css.decl.CSSExpressionMemberTermURI;
import vuegwt.shaded.com.helger.css.decl.ECSSExpressionOperator;
import vuegwt.shaded.com.helger.css.decl.ICSSExpressionMember;

@NotThreadSafe
public class CSSExpression
implements ICSSWriteable,
ICSSSourceLocationAware {
    private final ICommonsList<ICSSExpressionMember> m_aMembers = new CommonsArrayList<ICSSExpressionMember>();
    private CSSSourceLocation m_aSourceLocation;

    @Nonnull
    public CSSExpression addMember(@Nonnull ICSSExpressionMember iCSSExpressionMember) {
        ValueEnforcer.notNull(iCSSExpressionMember, "ExpressionMember");
        this.m_aMembers.add(iCSSExpressionMember);
        return this;
    }

    @Nonnull
    public CSSExpression addMember(@Nonnegative int n, @Nonnull ICSSExpressionMember iCSSExpressionMember) {
        ValueEnforcer.isGE0(n, "Index");
        ValueEnforcer.notNull(iCSSExpressionMember, "ExpressionMember");
        if (n >= this.getMemberCount()) {
            this.m_aMembers.add(iCSSExpressionMember);
        } else {
            this.m_aMembers.add(n, iCSSExpressionMember);
        }
        return this;
    }

    @Nonnull
    public CSSExpression addTermSimple(@Nonnull @Nonempty String string) {
        return this.addMember(new CSSExpressionMemberTermSimple(string));
    }

    @Nonnull
    public CSSExpression addTermSimple(@Nonnegative int n, @Nonnull @Nonempty String string) {
        return this.addMember(n, new CSSExpressionMemberTermSimple(string));
    }

    @Nonnull
    public CSSExpression addNumber(int n) {
        return this.addMember(new CSSExpressionMemberTermSimple(n));
    }

    @Nonnull
    public CSSExpression addNumber(@Nonnegative int n, int n2) {
        return this.addMember(n, new CSSExpressionMemberTermSimple(n2));
    }

    @Nonnull
    public CSSExpression addNumber(long l) {
        return this.addMember(new CSSExpressionMemberTermSimple(l));
    }

    @Nonnull
    public CSSExpression addNumber(@Nonnegative int n, long l) {
        return this.addMember(n, new CSSExpressionMemberTermSimple(l));
    }

    @Nonnull
    public CSSExpression addNumber(float f) {
        return this.addMember(new CSSExpressionMemberTermSimple(f));
    }

    @Nonnull
    public CSSExpression addNumber(@Nonnegative int n, float f) {
        return this.addMember(n, new CSSExpressionMemberTermSimple(f));
    }

    @Nonnull
    public CSSExpression addNumber(double d) {
        return this.addMember(new CSSExpressionMemberTermSimple(d));
    }

    @Nonnull
    public CSSExpression addNumber(@Nonnegative int n, double d) {
        return this.addMember(n, new CSSExpressionMemberTermSimple(d));
    }

    @Nonnull
    @Nonempty
    private static String _createStringValue(@Nonnull String string) {
        return '\"' + StringHelper.replaceAll(string, "\"", "\\\"") + '\"';
    }

    @Nonnull
    public CSSExpression addString(@Nonnull String string) {
        return this.addTermSimple(CSSExpression._createStringValue(string));
    }

    @Nonnull
    public CSSExpression addString(@Nonnegative int n, @Nonnull String string) {
        return this.addTermSimple(n, CSSExpression._createStringValue(string));
    }

    @Nonnull
    public CSSExpression addURI(@Nonnull @Nonempty String string) {
        return this.addMember(new CSSExpressionMemberTermURI(string));
    }

    @Nonnull
    public CSSExpression addURI(@Nonnegative int n, @Nonnull @Nonempty String string) {
        return this.addMember(n, new CSSExpressionMemberTermURI(string));
    }

    @Nonnull
    public EChange removeMember(@Nullable ICSSExpressionMember iCSSExpressionMember) {
        return this.m_aMembers.removeObject(iCSSExpressionMember);
    }

    @Nonnull
    public EChange removeMember(@Nonnegative int n) {
        return this.m_aMembers.removeAtIndex(n);
    }

    @Nonnull
    public EChange removeAllMembers() {
        return this.m_aMembers.removeAll();
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<ICSSExpressionMember> getAllMembers() {
        return (ICommonsList)this.m_aMembers.getClone();
    }

    @Nullable
    public ICSSExpressionMember getMemberAtIndex(@Nonnegative int n) {
        return (ICSSExpressionMember)this.m_aMembers.getAtIndex(n);
    }

    @Nonnegative
    public int getMemberCount() {
        return this.m_aMembers.size();
    }

    @Nonnull
    public ICommonsList<CSSExpressionMemberTermSimple> getAllSimpleMembers() {
        return this.m_aMembers.getAllInstanceOf(CSSExpressionMemberTermSimple.class);
    }

    @Override
    @Nonnull
    public String getAsCSSString(@Nonnull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        for (ICSSExpressionMember iCSSExpressionMember : this.m_aMembers) {
            boolean bl2 = iCSSExpressionMember instanceof ECSSExpressionOperator;
            if (!bl2 && !bl && stringBuilder.length() > 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(iCSSExpressionMember.getAsCSSString(iCSSWriterSettings, n));
            bl = bl2;
        }
        return stringBuilder.toString();
    }

    @Override
    public void setSourceLocation(@Nullable CSSSourceLocation cSSSourceLocation) {
        this.m_aSourceLocation = cSSSourceLocation;
    }

    @Override
    @Nullable
    public CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSExpression cSSExpression = (CSSExpression)object;
        return this.m_aMembers.equals(cSSExpression.m_aMembers);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append(this.m_aMembers)).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("members", this.m_aMembers).appendIfNotNull("sourceLocation", this.m_aSourceLocation).getToString();
    }

    @Nonnull
    public static CSSExpression createSimple(@Nonnull @Nonempty String string) {
        return new CSSExpression().addTermSimple(string);
    }

    @Nonnull
    public static CSSExpression createString(@Nonnull @Nonempty String string) {
        return new CSSExpression().addString(string);
    }

    @Nonnull
    public static CSSExpression createNumber(int n) {
        return new CSSExpression().addNumber(n);
    }

    @Nonnull
    public static CSSExpression createNumber(long l) {
        return new CSSExpression().addNumber(l);
    }

    @Nonnull
    public static CSSExpression createNumber(float f) {
        return new CSSExpression().addNumber(f);
    }

    @Nonnull
    public static CSSExpression createNumber(double d) {
        return new CSSExpression().addNumber(d);
    }

    @Nonnull
    public static CSSExpression createURI(@Nonnull @Nonempty String string) {
        return new CSSExpression().addURI(string);
    }
}

