/*
 * Decompiled with CFR 0.152.
 */
package vuegwt.shaded.com.helger.css.decl;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import vuegwt.shaded.com.helger.commons.ValueEnforcer;
import vuegwt.shaded.com.helger.commons.annotation.Nonempty;
import vuegwt.shaded.com.helger.commons.annotation.ReturnsMutableCopy;
import vuegwt.shaded.com.helger.commons.collection.impl.CommonsArrayList;
import vuegwt.shaded.com.helger.commons.collection.impl.ICommonsList;
import vuegwt.shaded.com.helger.commons.hashcode.HashCodeGenerator;
import vuegwt.shaded.com.helger.commons.state.EChange;
import vuegwt.shaded.com.helger.commons.string.ToStringGenerator;
import vuegwt.shaded.com.helger.css.CSSSourceLocation;
import vuegwt.shaded.com.helger.css.ECSSVersion;
import vuegwt.shaded.com.helger.css.ICSSSourceLocationAware;
import vuegwt.shaded.com.helger.css.ICSSWriterSettings;
import vuegwt.shaded.com.helger.css.decl.ICSSExpressionMathMember;
import vuegwt.shaded.com.helger.css.decl.ICSSExpressionMember;

@NotThreadSafe
public class CSSExpressionMemberMath
implements ICSSExpressionMember,
ICSSExpressionMathMember,
ICSSSourceLocationAware {
    private final ICommonsList<ICSSExpressionMathMember> m_aMembers = new CommonsArrayList<ICSSExpressionMathMember>();
    private CSSSourceLocation m_aSourceLocation;

    public CSSExpressionMemberMath() {
    }

    public CSSExpressionMemberMath(@Nonnull Iterable<? extends ICSSExpressionMathMember> iterable) {
        this.m_aMembers.addAll(iterable);
    }

    @Nonnull
    public CSSExpressionMemberMath addMember(@Nonnull ICSSExpressionMathMember iCSSExpressionMathMember) {
        ValueEnforcer.notNull(iCSSExpressionMathMember, "Member");
        this.m_aMembers.add(iCSSExpressionMathMember);
        return this;
    }

    @Nonnull
    public CSSExpressionMemberMath addMember(@Nonnegative int n, @Nonnull ICSSExpressionMathMember iCSSExpressionMathMember) {
        ValueEnforcer.isGE0(n, "Index");
        ValueEnforcer.notNull(iCSSExpressionMathMember, "Member");
        if (n >= this.getMemberCount()) {
            this.m_aMembers.add(iCSSExpressionMathMember);
        } else {
            this.m_aMembers.add(n, iCSSExpressionMathMember);
        }
        return this;
    }

    @Nonnull
    public EChange removeMember(@Nonnull ICSSExpressionMathMember iCSSExpressionMathMember) {
        return this.m_aMembers.removeObject(iCSSExpressionMathMember);
    }

    @Nonnull
    public EChange removeMember(@Nonnegative int n) {
        return this.m_aMembers.removeAtIndex(n);
    }

    @Nonnull
    public EChange removeAllMembers() {
        return this.m_aMembers.removeAll();
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<ICSSExpressionMathMember> getAllMembers() {
        return (ICommonsList)this.m_aMembers.getClone();
    }

    @Nonnegative
    public int getMemberCount() {
        return this.m_aMembers.size();
    }

    @Override
    @Nonnull
    public CSSExpressionMemberMath getClone() {
        return new CSSExpressionMemberMath(this.m_aMembers);
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        iCSSWriterSettings.checkVersionRequirements(this);
        StringBuilder stringBuilder = new StringBuilder("calc(");
        for (ICSSExpressionMathMember iCSSExpressionMathMember : this.m_aMembers) {
            stringBuilder.append(iCSSExpressionMathMember.getAsCSSString(iCSSWriterSettings, n));
        }
        return stringBuilder.append(")").toString();
    }

    @Override
    @Nonnull
    public ECSSVersion getMinimumCSSVersion() {
        return ECSSVersion.CSS30;
    }

    @Override
    public void setSourceLocation(@Nullable CSSSourceLocation cSSSourceLocation) {
        this.m_aSourceLocation = cSSSourceLocation;
    }

    @Override
    @Nullable
    public CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSExpressionMemberMath cSSExpressionMemberMath = (CSSExpressionMemberMath)object;
        return this.m_aMembers.equals(cSSExpressionMemberMath.m_aMembers);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append(this.m_aMembers)).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("members", this.m_aMembers).appendIfNotNull("sourceLocation", this.m_aSourceLocation).getToString();
    }
}

