/*
 * Decompiled with CFR 0.152.
 */
package vuegwt.shaded.com.helger.css.decl;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import vuegwt.shaded.com.helger.commons.annotation.Nonempty;
import vuegwt.shaded.com.helger.commons.hashcode.HashCodeGenerator;
import vuegwt.shaded.com.helger.commons.string.StringHelper;
import vuegwt.shaded.com.helger.commons.string.ToStringGenerator;
import vuegwt.shaded.com.helger.css.CSSSourceLocation;
import vuegwt.shaded.com.helger.css.ECSSUnit;
import vuegwt.shaded.com.helger.css.ECSSVersion;
import vuegwt.shaded.com.helger.css.ICSSSourceLocationAware;
import vuegwt.shaded.com.helger.css.ICSSWriterSettings;
import vuegwt.shaded.com.helger.css.decl.ICSSExpressionMathMember;
import vuegwt.shaded.com.helger.css.utils.CSSNumberHelper;

@NotThreadSafe
public class CSSExpressionMemberMathUnitSimple
implements ICSSExpressionMathMember,
ICSSSourceLocationAware {
    private final String m_sText;
    private final ECSSUnit m_eUnit;
    private CSSSourceLocation m_aSourceLocation;

    public CSSExpressionMemberMathUnitSimple(@Nonnull @Nonempty String string) {
        if (StringHelper.hasNoTextAfterTrim(string)) {
            throw new IllegalArgumentException("text");
        }
        this.m_sText = string.trim();
        this.m_eUnit = CSSNumberHelper.getMatchingUnitExclPercentage(this.m_sText);
    }

    @Nonnull
    public String getText() {
        return this.m_sText;
    }

    @Nullable
    public ECSSUnit getUnit() {
        return this.m_eUnit;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        iCSSWriterSettings.checkVersionRequirements(this);
        return this.m_sText;
    }

    @Override
    @Nonnull
    public ECSSVersion getMinimumCSSVersion() {
        return ECSSVersion.CSS30;
    }

    @Override
    public void setSourceLocation(@Nullable CSSSourceLocation cSSSourceLocation) {
        this.m_aSourceLocation = cSSSourceLocation;
    }

    @Override
    @Nullable
    public CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSExpressionMemberMathUnitSimple cSSExpressionMemberMathUnitSimple = (CSSExpressionMemberMathUnitSimple)object;
        return this.m_sText.equals(cSSExpressionMemberMathUnitSimple.m_sText);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_sText).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("text", this.m_sText).append("unit", this.m_eUnit).appendIfNotNull("sourceLocation", this.m_aSourceLocation).getToString();
    }
}

