/*
 * Decompiled with CFR 0.152.
 */
package vuegwt.shaded.com.helger.css.decl;

import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import vuegwt.shaded.com.helger.commons.annotation.Nonempty;
import vuegwt.shaded.com.helger.commons.collection.impl.CommonsArrayList;
import vuegwt.shaded.com.helger.commons.collection.impl.ICommonsList;
import vuegwt.shaded.com.helger.css.ECSSUnit;

@Immutable
public final class CSSExpressionTermOptimizer {
    private static final ICommonsList<String> s_aUnitValues0 = new CommonsArrayList<String>();
    private static final CSSExpressionTermOptimizer s_aInstance;

    private CSSExpressionTermOptimizer() {
    }

    @Nonnull
    @Nonempty
    public static String getOptimizedValue(@Nonnull @Nonempty String string) {
        if (s_aUnitValues0.contains(string)) {
            return "0";
        }
        if (string.length() == 7 && string.charAt(0) == '#' && string.charAt(1) == string.charAt(2) && string.charAt(3) == string.charAt(4) && string.charAt(5) == string.charAt(6)) {
            return Character.toString('#') + string.charAt(1) + string.charAt(3) + string.charAt(5);
        }
        return string;
    }

    static {
        for (ECSSUnit eCSSUnit : ECSSUnit.values()) {
            s_aUnitValues0.add(eCSSUnit.format(0));
        }
        s_aInstance = new CSSExpressionTermOptimizer();
    }
}

