/*
 * Decompiled with CFR 0.152.
 */
package vuegwt.shaded.com.helger.css.decl;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import vuegwt.shaded.com.helger.commons.ValueEnforcer;
import vuegwt.shaded.com.helger.commons.annotation.Nonempty;
import vuegwt.shaded.com.helger.commons.annotation.ReturnsMutableCopy;
import vuegwt.shaded.com.helger.commons.collection.impl.ICommonsList;
import vuegwt.shaded.com.helger.commons.hashcode.HashCodeGenerator;
import vuegwt.shaded.com.helger.commons.state.EChange;
import vuegwt.shaded.com.helger.commons.string.StringHelper;
import vuegwt.shaded.com.helger.commons.string.ToStringGenerator;
import vuegwt.shaded.com.helger.css.CSSSourceLocation;
import vuegwt.shaded.com.helger.css.ECSSVersion;
import vuegwt.shaded.com.helger.css.ICSSSourceLocationAware;
import vuegwt.shaded.com.helger.css.ICSSVersionAware;
import vuegwt.shaded.com.helger.css.ICSSWriterSettings;
import vuegwt.shaded.com.helger.css.decl.CSSDeclaration;
import vuegwt.shaded.com.helger.css.decl.CSSDeclarationContainer;
import vuegwt.shaded.com.helger.css.decl.ICSSTopLevelRule;
import vuegwt.shaded.com.helger.css.decl.IHasCSSDeclarations;

@NotThreadSafe
public class CSSFontFaceRule
implements ICSSTopLevelRule,
IHasCSSDeclarations<CSSFontFaceRule>,
ICSSVersionAware,
ICSSSourceLocationAware {
    private final String m_sDeclaration;
    private final CSSDeclarationContainer m_aDeclarations = new CSSDeclarationContainer();
    private CSSSourceLocation m_aSourceLocation;

    public static boolean isValidDeclaration(@Nonnull @Nonempty String string) {
        return StringHelper.startsWith((CharSequence)string, '@') && StringHelper.endsWithIgnoreCase(string, "font-face");
    }

    public CSSFontFaceRule() {
        this("@font-face");
    }

    public CSSFontFaceRule(@Nonnull @Nonempty String string) {
        ValueEnforcer.isTrue(CSSFontFaceRule.isValidDeclaration(string), () -> "Declaration '" + string + "' is invalid");
        this.m_sDeclaration = string;
    }

    @Nonnull
    @Nonempty
    public String getDeclaration() {
        return this.m_sDeclaration;
    }

    @Override
    @Nonnull
    public CSSFontFaceRule addDeclaration(@Nonnull CSSDeclaration cSSDeclaration) {
        this.m_aDeclarations.addDeclaration(cSSDeclaration);
        return this;
    }

    @Override
    @Nonnull
    public CSSFontFaceRule addDeclaration(@Nonnegative int n, @Nonnull CSSDeclaration cSSDeclaration) {
        this.m_aDeclarations.addDeclaration(n, cSSDeclaration);
        return this;
    }

    @Override
    @Nonnull
    public EChange removeDeclaration(@Nonnull CSSDeclaration cSSDeclaration) {
        return this.m_aDeclarations.removeDeclaration(cSSDeclaration);
    }

    @Override
    @Nonnull
    public EChange removeDeclaration(@Nonnegative int n) {
        return this.m_aDeclarations.removeDeclaration(n);
    }

    @Override
    @Nonnull
    public EChange removeAllDeclarations() {
        return this.m_aDeclarations.removeAllDeclarations();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<CSSDeclaration> getAllDeclarations() {
        return this.m_aDeclarations.getAllDeclarations();
    }

    @Override
    @Nullable
    public CSSDeclaration getDeclarationAtIndex(@Nonnegative int n) {
        return this.m_aDeclarations.getDeclarationAtIndex(n);
    }

    @Override
    @Nonnull
    public CSSFontFaceRule setDeclarationAtIndex(@Nonnegative int n, @Nonnull CSSDeclaration cSSDeclaration) {
        this.m_aDeclarations.setDeclarationAtIndex(n, cSSDeclaration);
        return this;
    }

    @Override
    public boolean hasDeclarations() {
        return this.m_aDeclarations.hasDeclarations();
    }

    @Override
    @Nonnegative
    public int getDeclarationCount() {
        return this.m_aDeclarations.getDeclarationCount();
    }

    @Override
    @Nullable
    public CSSDeclaration getDeclarationOfPropertyName(@Nullable String string) {
        return this.m_aDeclarations.getDeclarationOfPropertyName(string);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<CSSDeclaration> getAllDeclarationsOfPropertyName(@Nullable String string) {
        return this.m_aDeclarations.getAllDeclarationsOfPropertyName(string);
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        iCSSWriterSettings.checkVersionRequirements(this);
        if (!iCSSWriterSettings.isWriteFontFaceRules()) {
            return "";
        }
        if (iCSSWriterSettings.isRemoveUnnecessaryCode() && !this.hasDeclarations()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(this.m_sDeclaration);
        stringBuilder.append(this.m_aDeclarations.getAsCSSString(iCSSWriterSettings, n));
        if (!iCSSWriterSettings.isOptimizedOutput()) {
            stringBuilder.append(iCSSWriterSettings.getNewLineString());
        }
        return stringBuilder.toString();
    }

    @Override
    @Nonnull
    public ECSSVersion getMinimumCSSVersion() {
        return ECSSVersion.CSS30;
    }

    @Override
    public void setSourceLocation(@Nullable CSSSourceLocation cSSSourceLocation) {
        this.m_aSourceLocation = cSSSourceLocation;
    }

    @Override
    @Nullable
    public CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSFontFaceRule cSSFontFaceRule = (CSSFontFaceRule)object;
        return this.m_aDeclarations.equals(cSSFontFaceRule.m_aDeclarations);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append((Iterable)this.m_aDeclarations)).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("declarations", this.m_aDeclarations).appendIfNotNull("sourceLocation", this.m_aSourceLocation).getToString();
    }
}

