/*
 * Decompiled with CFR 0.152.
 */
package vuegwt.shaded.com.helger.css.decl;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import vuegwt.shaded.com.helger.commons.ValueEnforcer;
import vuegwt.shaded.com.helger.commons.annotation.Nonempty;
import vuegwt.shaded.com.helger.commons.annotation.ReturnsMutableCopy;
import vuegwt.shaded.com.helger.commons.collection.impl.CommonsArrayList;
import vuegwt.shaded.com.helger.commons.collection.impl.ICommonsList;
import vuegwt.shaded.com.helger.commons.hashcode.HashCodeGenerator;
import vuegwt.shaded.com.helger.commons.state.EChange;
import vuegwt.shaded.com.helger.commons.string.StringHelper;
import vuegwt.shaded.com.helger.commons.string.ToStringGenerator;
import vuegwt.shaded.com.helger.css.CSSSourceLocation;
import vuegwt.shaded.com.helger.css.ICSSSourceLocationAware;
import vuegwt.shaded.com.helger.css.ICSSWriterSettings;
import vuegwt.shaded.com.helger.css.decl.AbstractHasTopLevelRules;
import vuegwt.shaded.com.helger.css.decl.CSSMediaQuery;
import vuegwt.shaded.com.helger.css.decl.ICSSTopLevelRule;

@NotThreadSafe
public class CSSMediaRule
extends AbstractHasTopLevelRules
implements ICSSTopLevelRule,
ICSSSourceLocationAware {
    private final ICommonsList<CSSMediaQuery> m_aMediaQueries = new CommonsArrayList<CSSMediaQuery>();
    private CSSSourceLocation m_aSourceLocation;

    public boolean hasMediaQueries() {
        return this.m_aMediaQueries.isNotEmpty();
    }

    @Nonnegative
    public int getMediaQueryCount() {
        return this.m_aMediaQueries.size();
    }

    @Nonnull
    public CSSMediaRule addMediaQuery(@Nonnull @Nonempty CSSMediaQuery cSSMediaQuery) {
        ValueEnforcer.notNull(cSSMediaQuery, "MediaQuery");
        this.m_aMediaQueries.add(cSSMediaQuery);
        return this;
    }

    @Nonnull
    public CSSMediaRule addMediaQuery(@Nonnegative int n, @Nonnull @Nonempty CSSMediaQuery cSSMediaQuery) {
        ValueEnforcer.isGE0(n, "Index");
        ValueEnforcer.notNull(cSSMediaQuery, "MediaQuery");
        if (n >= this.getMediaQueryCount()) {
            this.m_aMediaQueries.add(cSSMediaQuery);
        } else {
            this.m_aMediaQueries.add(n, cSSMediaQuery);
        }
        return this;
    }

    @Nonnull
    public EChange removeMediaQuery(@Nullable CSSMediaQuery cSSMediaQuery) {
        return this.m_aMediaQueries.removeObject(cSSMediaQuery);
    }

    @Nonnull
    public EChange removeMediaQuery(@Nonnegative int n) {
        return this.m_aMediaQueries.removeAtIndex(n);
    }

    @Nonnull
    public EChange removeAllMediaQueries() {
        return this.m_aMediaQueries.removeAll();
    }

    @Nullable
    public CSSMediaQuery getMediaQueryAtIndex(@Nonnegative int n) {
        return (CSSMediaQuery)this.m_aMediaQueries.getAtIndex(n);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<CSSMediaQuery> getAllMediaQueries() {
        return (ICommonsList)this.m_aMediaQueries.getClone();
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        if (!iCSSWriterSettings.isWriteMediaRules()) {
            return "";
        }
        boolean bl = iCSSWriterSettings.isOptimizedOutput();
        int n2 = this.m_aRules.size();
        if (iCSSWriterSettings.isRemoveUnnecessaryCode() && n2 == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder("@media ");
        boolean bl2 = true;
        for (CSSMediaQuery iCSSWriteable : this.m_aMediaQueries) {
            if (bl2) {
                bl2 = false;
            } else {
                stringBuilder.append(bl ? "," : ", ");
            }
            stringBuilder.append(iCSSWriteable.getAsCSSString(iCSSWriterSettings, n));
        }
        if (n2 == 0) {
            stringBuilder.append(bl ? "{}" : " {}" + iCSSWriterSettings.getNewLineString());
        } else {
            stringBuilder.append(bl ? "{" : " {" + iCSSWriterSettings.getNewLineString());
            bl2 = true;
            for (ICSSTopLevelRule iCSSTopLevelRule : this.m_aRules) {
                String string = iCSSTopLevelRule.getAsCSSString(iCSSWriterSettings, n + 1);
                if (!StringHelper.hasText(string)) continue;
                if (bl2) {
                    bl2 = false;
                } else if (!bl) {
                    stringBuilder.append(iCSSWriterSettings.getNewLineString());
                }
                if (!bl) {
                    stringBuilder.append(iCSSWriterSettings.getIndent(n + 1));
                }
                stringBuilder.append(string);
            }
            if (!bl) {
                stringBuilder.append(iCSSWriterSettings.getIndent(n));
            }
            stringBuilder.append('}');
            if (!bl) {
                stringBuilder.append(iCSSWriterSettings.getNewLineString());
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public void setSourceLocation(@Nullable CSSSourceLocation cSSSourceLocation) {
        this.m_aSourceLocation = cSSSourceLocation;
    }

    @Override
    @Nullable
    public CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSMediaRule cSSMediaRule = (CSSMediaRule)object;
        return this.m_aMediaQueries.equals(cSSMediaRule.m_aMediaQueries) && this.m_aRules.equals(cSSMediaRule.m_aRules);
    }

    public int hashCode() {
        return ((HashCodeGenerator)((HashCodeGenerator)new HashCodeGenerator(this).append(this.m_aMediaQueries)).append((Iterable)this.m_aRules)).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("mediaQueries", this.m_aMediaQueries).append("styleRules", this.m_aRules).appendIfNotNull("sourceLocation", this.m_aSourceLocation).getToString();
    }
}

