/*
 * Decompiled with CFR 0.152.
 */
package vuegwt.shaded.com.helger.css.decl;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import vuegwt.shaded.com.helger.commons.ValueEnforcer;
import vuegwt.shaded.com.helger.commons.annotation.Nonempty;
import vuegwt.shaded.com.helger.commons.annotation.ReturnsMutableCopy;
import vuegwt.shaded.com.helger.commons.collection.impl.ICommonsList;
import vuegwt.shaded.com.helger.commons.hashcode.HashCodeGenerator;
import vuegwt.shaded.com.helger.commons.state.EChange;
import vuegwt.shaded.com.helger.commons.string.StringHelper;
import vuegwt.shaded.com.helger.commons.string.ToStringGenerator;
import vuegwt.shaded.com.helger.css.CSSSourceLocation;
import vuegwt.shaded.com.helger.css.ECSSVersion;
import vuegwt.shaded.com.helger.css.ICSSVersionAware;
import vuegwt.shaded.com.helger.css.ICSSWriterSettings;
import vuegwt.shaded.com.helger.css.decl.CSSDeclaration;
import vuegwt.shaded.com.helger.css.decl.CSSDeclarationContainer;
import vuegwt.shaded.com.helger.css.decl.ICSSPageRuleMember;
import vuegwt.shaded.com.helger.css.decl.IHasCSSDeclarations;

public class CSSPageMarginBlock
implements ICSSPageRuleMember,
ICSSVersionAware,
IHasCSSDeclarations<CSSPageMarginBlock> {
    private String m_sPageMarginSymbol;
    private final CSSDeclarationContainer m_aDeclarations = new CSSDeclarationContainer();
    private CSSSourceLocation m_aSourceLocation;

    public CSSPageMarginBlock(@Nonnull @Nonempty String string) {
        this.setPageMarginSymbol(string);
    }

    @Nonnull
    @Nonempty
    public String getPageMarginSymbol() {
        return this.m_sPageMarginSymbol;
    }

    @Nonnull
    public CSSPageMarginBlock setPageMarginSymbol(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "PargeMarginSymbol");
        ValueEnforcer.isTrue(StringHelper.startsWith((CharSequence)string, '@'), "Page margin symbol does not start with '@'!");
        this.m_sPageMarginSymbol = string;
        return this;
    }

    @Override
    @Nonnull
    public CSSPageMarginBlock addDeclaration(@Nonnull CSSDeclaration cSSDeclaration) {
        this.m_aDeclarations.addDeclaration(cSSDeclaration);
        return this;
    }

    @Override
    @Nonnull
    public CSSPageMarginBlock addDeclaration(@Nonnegative int n, @Nonnull CSSDeclaration cSSDeclaration) {
        this.m_aDeclarations.addDeclaration(n, cSSDeclaration);
        return this;
    }

    @Override
    @Nonnull
    public EChange removeDeclaration(@Nonnull CSSDeclaration cSSDeclaration) {
        return this.m_aDeclarations.removeDeclaration(cSSDeclaration);
    }

    @Override
    @Nonnull
    public EChange removeDeclaration(@Nonnegative int n) {
        return this.m_aDeclarations.removeDeclaration(n);
    }

    @Override
    @Nonnull
    public EChange removeAllDeclarations() {
        return this.m_aDeclarations.removeAllDeclarations();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<CSSDeclaration> getAllDeclarations() {
        return this.m_aDeclarations.getAllDeclarations();
    }

    @Override
    @Nullable
    public CSSDeclaration getDeclarationAtIndex(@Nonnegative int n) {
        return this.m_aDeclarations.getDeclarationAtIndex(n);
    }

    @Override
    @Nonnull
    public CSSPageMarginBlock setDeclarationAtIndex(@Nonnegative int n, @Nonnull CSSDeclaration cSSDeclaration) {
        this.m_aDeclarations.setDeclarationAtIndex(n, cSSDeclaration);
        return this;
    }

    @Override
    public boolean hasDeclarations() {
        return this.m_aDeclarations.hasDeclarations();
    }

    @Override
    @Nonnegative
    public int getDeclarationCount() {
        return this.m_aDeclarations.getDeclarationCount();
    }

    @Override
    @Nullable
    public CSSDeclaration getDeclarationOfPropertyName(@Nullable String string) {
        return this.m_aDeclarations.getDeclarationOfPropertyName(string);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<CSSDeclaration> getAllDeclarationsOfPropertyName(@Nullable String string) {
        return this.m_aDeclarations.getAllDeclarationsOfPropertyName(string);
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        iCSSWriterSettings.checkVersionRequirements(this);
        if (iCSSWriterSettings.isRemoveUnnecessaryCode() && !this.hasDeclarations()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.m_sPageMarginSymbol);
        stringBuilder.append(this.m_aDeclarations.getAsCSSString(iCSSWriterSettings, n));
        return stringBuilder.toString();
    }

    @Override
    @Nonnull
    public ECSSVersion getMinimumCSSVersion() {
        return ECSSVersion.CSS30;
    }

    public void setSourceLocation(@Nullable CSSSourceLocation cSSSourceLocation) {
        this.m_aSourceLocation = cSSSourceLocation;
    }

    @Nullable
    public CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSPageMarginBlock cSSPageMarginBlock = (CSSPageMarginBlock)object;
        return this.m_sPageMarginSymbol.equals(cSSPageMarginBlock.m_sPageMarginSymbol) && this.m_aDeclarations.equals(cSSPageMarginBlock.m_aDeclarations);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append(this.m_sPageMarginSymbol).append((Iterable)this.m_aDeclarations)).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("pageMarginSymbol", this.m_sPageMarginSymbol).append("declarations", this.m_aDeclarations).appendIfNotNull("sourceLocation", this.m_aSourceLocation).getToString();
    }
}

