/*
 * Decompiled with CFR 0.152.
 */
package vuegwt.shaded.com.helger.css.decl;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import vuegwt.shaded.com.helger.commons.ValueEnforcer;
import vuegwt.shaded.com.helger.commons.annotation.Nonempty;
import vuegwt.shaded.com.helger.commons.equals.EqualsHelper;
import vuegwt.shaded.com.helger.commons.hashcode.HashCodeGenerator;
import vuegwt.shaded.com.helger.commons.string.StringHelper;
import vuegwt.shaded.com.helger.commons.string.ToStringGenerator;
import vuegwt.shaded.com.helger.css.CSSSourceLocation;
import vuegwt.shaded.com.helger.css.ICSSSourceLocationAware;
import vuegwt.shaded.com.helger.css.ICSSWriterSettings;
import vuegwt.shaded.com.helger.css.decl.ECSSAttributeOperator;
import vuegwt.shaded.com.helger.css.decl.ICSSSelectorMember;

@NotThreadSafe
public class CSSSelectorAttribute
implements ICSSSelectorMember,
ICSSSourceLocationAware {
    private final String m_sNamespacePrefix;
    private final String m_sAttrName;
    private final ECSSAttributeOperator m_eOperator;
    private final String m_sAttrValue;
    private CSSSourceLocation m_aSourceLocation;

    private static boolean _isValidNamespacePrefix(@Nullable String string) {
        return StringHelper.hasNoText(string) || string.endsWith("|");
    }

    public CSSSelectorAttribute(@Nullable String string, @Nonnull @Nonempty String string2) {
        if (!CSSSelectorAttribute._isValidNamespacePrefix(string)) {
            throw new IllegalArgumentException("namespacePrefix is illegal!");
        }
        ValueEnforcer.notEmpty(string2, "AttrName");
        this.m_sNamespacePrefix = string;
        this.m_sAttrName = string2;
        this.m_eOperator = null;
        this.m_sAttrValue = null;
    }

    public CSSSelectorAttribute(@Nullable String string, @Nonnull @Nonempty String string2, @Nonnull ECSSAttributeOperator eCSSAttributeOperator, @Nonnull String string3) {
        if (!CSSSelectorAttribute._isValidNamespacePrefix(string)) {
            throw new IllegalArgumentException("namespacePrefix is illegal!");
        }
        ValueEnforcer.notEmpty(string2, "AttrName");
        ValueEnforcer.notNull(eCSSAttributeOperator, "Operator");
        ValueEnforcer.notNull(string3, "AttrValue");
        this.m_sNamespacePrefix = string;
        this.m_sAttrName = string2;
        this.m_eOperator = eCSSAttributeOperator;
        this.m_sAttrValue = string3;
    }

    @Nullable
    public String getNamespacePrefix() {
        return this.m_sNamespacePrefix;
    }

    @Nonnull
    @Nonempty
    public String getAttrName() {
        return this.m_sAttrName;
    }

    @Nullable
    public ECSSAttributeOperator getOperator() {
        return this.m_eOperator;
    }

    @Nullable
    public String getAttrValue() {
        return this.m_sAttrValue;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        if (StringHelper.hasText(this.m_sNamespacePrefix)) {
            stringBuilder.append(this.m_sNamespacePrefix);
        }
        stringBuilder.append(this.m_sAttrName);
        if (this.m_eOperator != null) {
            stringBuilder.append(this.m_eOperator.getAsCSSString(iCSSWriterSettings, n)).append(this.m_sAttrValue);
        }
        return stringBuilder.append(']').toString();
    }

    @Override
    public void setSourceLocation(@Nullable CSSSourceLocation cSSSourceLocation) {
        this.m_aSourceLocation = cSSSourceLocation;
    }

    @Override
    @Nullable
    public CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSSelectorAttribute cSSSelectorAttribute = (CSSSelectorAttribute)object;
        return EqualsHelper.equals(this.m_sNamespacePrefix, cSSSelectorAttribute.m_sNamespacePrefix) && this.m_sAttrName.equals(cSSSelectorAttribute.m_sAttrName) && EqualsHelper.equals(this.m_eOperator, cSSSelectorAttribute.m_eOperator) && EqualsHelper.equals(this.m_sAttrValue, cSSSelectorAttribute.m_sAttrValue);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append(this.m_sNamespacePrefix).append(this.m_sAttrName).append((Enum)this.m_eOperator)).append(this.m_sAttrValue).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).appendIfNotNull("namespacePrefix", this.m_sNamespacePrefix).append("attrName", this.m_sAttrName).appendIfNotNull("operator", this.m_eOperator).appendIfNotNull("attrValue", this.m_sAttrValue).appendIfNotNull("sourceLocation", this.m_aSourceLocation).getToString();
    }
}

